package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetMediaPipelineResponse(
    mediaPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaPipeline
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineResponse = {
    import GetMediaPipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineResponse
      .builder()
      .optionallyWith(mediaPipeline.map(value => value.buildAwsValue()))(
        _.mediaPipeline
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.GetMediaPipelineResponse.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.GetMediaPipelineResponse
      .wrap(buildAwsValue())
}
object GetMediaPipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.GetMediaPipelineResponse =
      zio.aws.chimesdkmediapipelines.model
        .GetMediaPipelineResponse(mediaPipeline.map(value => value.asEditable))
    def mediaPipeline
        : Optional[zio.aws.chimesdkmediapipelines.model.MediaPipeline.ReadOnly]
    def getMediaPipeline: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaPipeline.ReadOnly
    ] = AwsError.unwrapOptionField("mediaPipeline", mediaPipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineResponse
  ) extends zio.aws.chimesdkmediapipelines.model.GetMediaPipelineResponse.ReadOnly {
    override val mediaPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaPipeline.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaPipeline())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.MediaPipeline.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineResponse
  ): zio.aws.chimesdkmediapipelines.model.GetMediaPipelineResponse.ReadOnly =
    new Wrapper(impl)
}
