package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.GuidString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteMediaPipelineRequest(mediaPipelineId: GuidString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineRequest = {
    import DeleteMediaPipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineRequest
      .builder()
      .mediaPipelineId(GuidString.unwrap(mediaPipelineId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.DeleteMediaPipelineRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.DeleteMediaPipelineRequest
      .wrap(buildAwsValue())
}
object DeleteMediaPipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.DeleteMediaPipelineRequest =
      zio.aws.chimesdkmediapipelines.model
        .DeleteMediaPipelineRequest(mediaPipelineId)
    def mediaPipelineId: GuidString
    def getMediaPipelineId: ZIO[Any, Nothing, GuidString] =
      ZIO.succeed(mediaPipelineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineRequest
  ) extends zio.aws.chimesdkmediapipelines.model.DeleteMediaPipelineRequest.ReadOnly {
    override val mediaPipelineId: GuidString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .GuidString(impl.mediaPipelineId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineRequest
  ): zio.aws.chimesdkmediapipelines.model.DeleteMediaPipelineRequest.ReadOnly =
    new Wrapper(impl)
}
