package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChimeSdkMeetingLiveConnectorConfiguration(
    arn: Arn,
    muxType: zio.aws.chimesdkmediapipelines.model.LiveConnectorMuxType,
    compositedVideo: Optional[
      zio.aws.chimesdkmediapipelines.model.CompositedVideoArtifactsConfiguration
    ] = Optional.Absent,
    sourceConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.SourceConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMeetingLiveConnectorConfiguration = {
    import ChimeSdkMeetingLiveConnectorConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMeetingLiveConnectorConfiguration
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .muxType(muxType.unwrap)
      .optionallyWith(compositedVideo.map(value => value.buildAwsValue()))(
        _.compositedVideo
      )
      .optionallyWith(sourceConfiguration.map(value => value.buildAwsValue()))(
        _.sourceConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingLiveConnectorConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingLiveConnectorConfiguration
      .wrap(buildAwsValue())
}
object ChimeSdkMeetingLiveConnectorConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMeetingLiveConnectorConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingLiveConnectorConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .ChimeSdkMeetingLiveConnectorConfiguration(
          arn,
          muxType,
          compositedVideo.map(value => value.asEditable),
          sourceConfiguration.map(value => value.asEditable)
        )
    def arn: Arn
    def muxType: zio.aws.chimesdkmediapipelines.model.LiveConnectorMuxType
    def compositedVideo: Optional[
      zio.aws.chimesdkmediapipelines.model.CompositedVideoArtifactsConfiguration.ReadOnly
    ]
    def sourceConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.SourceConfiguration.ReadOnly
    ]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getMuxType: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.LiveConnectorMuxType
    ] = ZIO.succeed(muxType)
    def getCompositedVideo: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.CompositedVideoArtifactsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("compositedVideo", compositedVideo)
    def getSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.SourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("sourceConfiguration", sourceConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMeetingLiveConnectorConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingLiveConnectorConfiguration.ReadOnly {
    override val arn: Arn =
      zio.aws.chimesdkmediapipelines.model.primitives.Arn(impl.arn())
    override val muxType
        : zio.aws.chimesdkmediapipelines.model.LiveConnectorMuxType =
      zio.aws.chimesdkmediapipelines.model.LiveConnectorMuxType
        .wrap(impl.muxType())
    override val compositedVideo: Optional[
      zio.aws.chimesdkmediapipelines.model.CompositedVideoArtifactsConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.compositedVideo())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.CompositedVideoArtifactsConfiguration
          .wrap(value)
      )
    override val sourceConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.SourceConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.SourceConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMeetingLiveConnectorConfiguration
  ): zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingLiveConnectorConfiguration.ReadOnly =
    new Wrapper(impl)
}
