package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class S3BucketSinkConfiguration(destination: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.S3BucketSinkConfiguration = {
    import S3BucketSinkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.S3BucketSinkConfiguration
      .builder()
      .destination(Arn.unwrap(destination): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.S3BucketSinkConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.S3BucketSinkConfiguration
      .wrap(buildAwsValue())
}
object S3BucketSinkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.S3BucketSinkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.S3BucketSinkConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .S3BucketSinkConfiguration(destination)
    def destination: Arn
    def getDestination: ZIO[Any, Nothing, Arn] = ZIO.succeed(destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.S3BucketSinkConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.S3BucketSinkConfiguration.ReadOnly {
    override val destination: Arn =
      zio.aws.chimesdkmediapipelines.model.primitives.Arn(impl.destination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.S3BucketSinkConfiguration
  ): zio.aws.chimesdkmediapipelines.model.S3BucketSinkConfiguration.ReadOnly =
    new Wrapper(impl)
}
