package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{
  ClientRequestToken,
  Arn,
  NonEmptyString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartSpeakerSearchTaskRequest(
    identifier: NonEmptyString,
    voiceProfileDomainArn: Arn,
    kinesisVideoStreamSourceTaskConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration
    ] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.StartSpeakerSearchTaskRequest = {
    import StartSpeakerSearchTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.StartSpeakerSearchTaskRequest
      .builder()
      .identifier(NonEmptyString.unwrap(identifier): java.lang.String)
      .voiceProfileDomainArn(
        Arn.unwrap(voiceProfileDomainArn): java.lang.String
      )
      .optionallyWith(
        kinesisVideoStreamSourceTaskConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.kinesisVideoStreamSourceTaskConfiguration)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.StartSpeakerSearchTaskRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.StartSpeakerSearchTaskRequest
      .wrap(buildAwsValue())
}
object StartSpeakerSearchTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.StartSpeakerSearchTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.StartSpeakerSearchTaskRequest =
      zio.aws.chimesdkmediapipelines.model.StartSpeakerSearchTaskRequest(
        identifier,
        voiceProfileDomainArn,
        kinesisVideoStreamSourceTaskConfiguration.map(value =>
          value.asEditable
        ),
        clientRequestToken.map(value => value)
      )
    def identifier: NonEmptyString
    def voiceProfileDomainArn: Arn
    def kinesisVideoStreamSourceTaskConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration.ReadOnly
    ]
    def clientRequestToken: Optional[ClientRequestToken]
    def getIdentifier: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(identifier)
    def getVoiceProfileDomainArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(voiceProfileDomainArn)
    def getKinesisVideoStreamSourceTaskConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisVideoStreamSourceTaskConfiguration",
      kinesisVideoStreamSourceTaskConfiguration
    )
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.StartSpeakerSearchTaskRequest
  ) extends zio.aws.chimesdkmediapipelines.model.StartSpeakerSearchTaskRequest.ReadOnly {
    override val identifier: NonEmptyString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .NonEmptyString(impl.identifier())
    override val voiceProfileDomainArn: Arn =
      zio.aws.chimesdkmediapipelines.model.primitives
        .Arn(impl.voiceProfileDomainArn())
    override val kinesisVideoStreamSourceTaskConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisVideoStreamSourceTaskConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration
          .wrap(value)
      )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.StartSpeakerSearchTaskRequest
  ): zio.aws.chimesdkmediapipelines.model.StartSpeakerSearchTaskRequest.ReadOnly =
    new Wrapper(impl)
}
