package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class MediaStreamSource(
    sourceType: zio.aws.chimesdkmediapipelines.model.MediaPipelineSourceType,
    sourceArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSource = {
    import MediaStreamSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSource
      .builder()
      .sourceType(sourceType.unwrap)
      .sourceArn(Arn.unwrap(sourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.MediaStreamSource.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.MediaStreamSource.wrap(buildAwsValue())
}
object MediaStreamSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmediapipelines.model.MediaStreamSource =
      zio.aws.chimesdkmediapipelines.model
        .MediaStreamSource(sourceType, sourceArn)
    def sourceType: zio.aws.chimesdkmediapipelines.model.MediaPipelineSourceType
    def sourceArn: Arn
    def getSourceType: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.MediaPipelineSourceType
    ] = ZIO.succeed(sourceType)
    def getSourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(sourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSource
  ) extends zio.aws.chimesdkmediapipelines.model.MediaStreamSource.ReadOnly {
    override val sourceType
        : zio.aws.chimesdkmediapipelines.model.MediaPipelineSourceType =
      zio.aws.chimesdkmediapipelines.model.MediaPipelineSourceType
        .wrap(impl.sourceType())
    override val sourceArn: Arn =
      zio.aws.chimesdkmediapipelines.model.primitives.Arn(impl.sourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSource
  ): zio.aws.chimesdkmediapipelines.model.MediaStreamSource.ReadOnly =
    new Wrapper(impl)
}
