package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KinesisDataStreamSinkConfiguration(
    insightsTarget: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisDataStreamSinkConfiguration = {
    import KinesisDataStreamSinkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisDataStreamSinkConfiguration
      .builder()
      .optionallyWith(
        insightsTarget.map(value => Arn.unwrap(value): java.lang.String)
      )(_.insightsTarget)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.KinesisDataStreamSinkConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.KinesisDataStreamSinkConfiguration
      .wrap(buildAwsValue())
}
object KinesisDataStreamSinkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisDataStreamSinkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.KinesisDataStreamSinkConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .KinesisDataStreamSinkConfiguration(insightsTarget.map(value => value))
    def insightsTarget: Optional[Arn]
    def getInsightsTarget: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("insightsTarget", insightsTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisDataStreamSinkConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.KinesisDataStreamSinkConfiguration.ReadOnly {
    override val insightsTarget: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.insightsTarget())
      .map(value => zio.aws.chimesdkmediapipelines.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisDataStreamSinkConfiguration
  ): zio.aws.chimesdkmediapipelines.model.KinesisDataStreamSinkConfiguration.ReadOnly =
    new Wrapper(impl)
}
