package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{
  GuidString,
  NonEmptyString
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetSpeakerSearchTaskRequest(
    identifier: NonEmptyString,
    speakerSearchTaskId: GuidString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.GetSpeakerSearchTaskRequest = {
    import GetSpeakerSearchTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetSpeakerSearchTaskRequest
      .builder()
      .identifier(NonEmptyString.unwrap(identifier): java.lang.String)
      .speakerSearchTaskId(
        GuidString.unwrap(speakerSearchTaskId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.GetSpeakerSearchTaskRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.GetSpeakerSearchTaskRequest
      .wrap(buildAwsValue())
}
object GetSpeakerSearchTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetSpeakerSearchTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.GetSpeakerSearchTaskRequest =
      zio.aws.chimesdkmediapipelines.model
        .GetSpeakerSearchTaskRequest(identifier, speakerSearchTaskId)
    def identifier: NonEmptyString
    def speakerSearchTaskId: GuidString
    def getIdentifier: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(identifier)
    def getSpeakerSearchTaskId: ZIO[Any, Nothing, GuidString] =
      ZIO.succeed(speakerSearchTaskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetSpeakerSearchTaskRequest
  ) extends zio.aws.chimesdkmediapipelines.model.GetSpeakerSearchTaskRequest.ReadOnly {
    override val identifier: NonEmptyString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .NonEmptyString(impl.identifier())
    override val speakerSearchTaskId: GuidString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .GuidString(impl.speakerSearchTaskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetSpeakerSearchTaskRequest
  ): zio.aws.chimesdkmediapipelines.model.GetSpeakerSearchTaskRequest.ReadOnly =
    new Wrapper(impl)
}
