package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VoiceAnalyticsProcessorConfiguration(
    speakerSearchStatus: Optional[
      zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsConfigurationStatus
    ] = Optional.Absent,
    voiceToneAnalysisStatus: Optional[
      zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsConfigurationStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.VoiceAnalyticsProcessorConfiguration = {
    import VoiceAnalyticsProcessorConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.VoiceAnalyticsProcessorConfiguration
      .builder()
      .optionallyWith(speakerSearchStatus.map(value => value.unwrap))(
        _.speakerSearchStatus
      )
      .optionallyWith(voiceToneAnalysisStatus.map(value => value.unwrap))(
        _.voiceToneAnalysisStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsProcessorConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsProcessorConfiguration
      .wrap(buildAwsValue())
}
object VoiceAnalyticsProcessorConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.VoiceAnalyticsProcessorConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsProcessorConfiguration =
      zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsProcessorConfiguration(
        speakerSearchStatus.map(value => value),
        voiceToneAnalysisStatus.map(value => value)
      )
    def speakerSearchStatus: Optional[
      zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsConfigurationStatus
    ]
    def voiceToneAnalysisStatus: Optional[
      zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsConfigurationStatus
    ]
    def getSpeakerSearchStatus: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsConfigurationStatus
    ] = AwsError.unwrapOptionField("speakerSearchStatus", speakerSearchStatus)
    def getVoiceToneAnalysisStatus: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsConfigurationStatus
    ] = AwsError.unwrapOptionField(
      "voiceToneAnalysisStatus",
      voiceToneAnalysisStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.VoiceAnalyticsProcessorConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsProcessorConfiguration.ReadOnly {
    override val speakerSearchStatus: Optional[
      zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsConfigurationStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.speakerSearchStatus())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsConfigurationStatus
          .wrap(value)
      )
    override val voiceToneAnalysisStatus: Optional[
      zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsConfigurationStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.voiceToneAnalysisStatus())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsConfigurationStatus
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.VoiceAnalyticsProcessorConfiguration
  ): zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsProcessorConfiguration.ReadOnly =
    new Wrapper(impl)
}
