package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartVoiceToneAnalysisTaskResponse(
    voiceToneAnalysisTask: Optional[
      zio.aws.chimesdkmediapipelines.model.VoiceToneAnalysisTask
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskResponse = {
    import StartVoiceToneAnalysisTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskResponse
      .builder()
      .optionallyWith(
        voiceToneAnalysisTask.map(value => value.buildAwsValue())
      )(_.voiceToneAnalysisTask)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskResponse.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskResponse
      .wrap(buildAwsValue())
}
object StartVoiceToneAnalysisTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskResponse =
      zio.aws.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskResponse(
        voiceToneAnalysisTask.map(value => value.asEditable)
      )
    def voiceToneAnalysisTask: Optional[
      zio.aws.chimesdkmediapipelines.model.VoiceToneAnalysisTask.ReadOnly
    ]
    def getVoiceToneAnalysisTask: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.VoiceToneAnalysisTask.ReadOnly
    ] =
      AwsError.unwrapOptionField("voiceToneAnalysisTask", voiceToneAnalysisTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskResponse
  ) extends zio.aws.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskResponse.ReadOnly {
    override val voiceToneAnalysisTask: Optional[
      zio.aws.chimesdkmediapipelines.model.VoiceToneAnalysisTask.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.voiceToneAnalysisTask())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.VoiceToneAnalysisTask.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskResponse
  ): zio.aws.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskResponse.ReadOnly =
    new Wrapper(impl)
}
