package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{
  ClientRequestToken,
  NonEmptyString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartVoiceToneAnalysisTaskRequest(
    identifier: NonEmptyString,
    languageCode: zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsLanguageCode,
    kinesisVideoStreamSourceTaskConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration
    ] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskRequest = {
    import StartVoiceToneAnalysisTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskRequest
      .builder()
      .identifier(NonEmptyString.unwrap(identifier): java.lang.String)
      .languageCode(languageCode.unwrap)
      .optionallyWith(
        kinesisVideoStreamSourceTaskConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.kinesisVideoStreamSourceTaskConfiguration)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskRequest
      .wrap(buildAwsValue())
}
object StartVoiceToneAnalysisTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskRequest =
      zio.aws.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskRequest(
        identifier,
        languageCode,
        kinesisVideoStreamSourceTaskConfiguration.map(value =>
          value.asEditable
        ),
        clientRequestToken.map(value => value)
      )
    def identifier: NonEmptyString
    def languageCode
        : zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsLanguageCode
    def kinesisVideoStreamSourceTaskConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration.ReadOnly
    ]
    def clientRequestToken: Optional[ClientRequestToken]
    def getIdentifier: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(identifier)
    def getLanguageCode: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsLanguageCode
    ] = ZIO.succeed(languageCode)
    def getKinesisVideoStreamSourceTaskConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisVideoStreamSourceTaskConfiguration",
      kinesisVideoStreamSourceTaskConfiguration
    )
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskRequest
  ) extends zio.aws.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskRequest.ReadOnly {
    override val identifier: NonEmptyString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .NonEmptyString(impl.identifier())
    override val languageCode
        : zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsLanguageCode =
      zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsLanguageCode
        .wrap(impl.languageCode())
    override val kinesisVideoStreamSourceTaskConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisVideoStreamSourceTaskConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration
          .wrap(value)
      )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskRequest
  ): zio.aws.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskRequest.ReadOnly =
    new Wrapper(impl)
}
