package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GridViewConfiguration(
    contentShareLayout: zio.aws.chimesdkmediapipelines.model.ContentShareLayoutOption,
    presenterOnlyConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.PresenterOnlyConfiguration
    ] = Optional.Absent,
    activeSpeakerOnlyConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.ActiveSpeakerOnlyConfiguration
    ] = Optional.Absent,
    horizontalLayoutConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.HorizontalLayoutConfiguration
    ] = Optional.Absent,
    verticalLayoutConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.VerticalLayoutConfiguration
    ] = Optional.Absent,
    videoAttribute: Optional[
      zio.aws.chimesdkmediapipelines.model.VideoAttribute
    ] = Optional.Absent,
    canvasOrientation: Optional[
      zio.aws.chimesdkmediapipelines.model.CanvasOrientation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.GridViewConfiguration = {
    import GridViewConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GridViewConfiguration
      .builder()
      .contentShareLayout(contentShareLayout.unwrap)
      .optionallyWith(
        presenterOnlyConfiguration.map(value => value.buildAwsValue())
      )(_.presenterOnlyConfiguration)
      .optionallyWith(
        activeSpeakerOnlyConfiguration.map(value => value.buildAwsValue())
      )(_.activeSpeakerOnlyConfiguration)
      .optionallyWith(
        horizontalLayoutConfiguration.map(value => value.buildAwsValue())
      )(_.horizontalLayoutConfiguration)
      .optionallyWith(
        verticalLayoutConfiguration.map(value => value.buildAwsValue())
      )(_.verticalLayoutConfiguration)
      .optionallyWith(videoAttribute.map(value => value.buildAwsValue()))(
        _.videoAttribute
      )
      .optionallyWith(canvasOrientation.map(value => value.unwrap))(
        _.canvasOrientation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.GridViewConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.GridViewConfiguration
      .wrap(buildAwsValue())
}
object GridViewConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GridViewConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmediapipelines.model.GridViewConfiguration =
      zio.aws.chimesdkmediapipelines.model.GridViewConfiguration(
        contentShareLayout,
        presenterOnlyConfiguration.map(value => value.asEditable),
        activeSpeakerOnlyConfiguration.map(value => value.asEditable),
        horizontalLayoutConfiguration.map(value => value.asEditable),
        verticalLayoutConfiguration.map(value => value.asEditable),
        videoAttribute.map(value => value.asEditable),
        canvasOrientation.map(value => value)
      )
    def contentShareLayout
        : zio.aws.chimesdkmediapipelines.model.ContentShareLayoutOption
    def presenterOnlyConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.PresenterOnlyConfiguration.ReadOnly
    ]
    def activeSpeakerOnlyConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.ActiveSpeakerOnlyConfiguration.ReadOnly
    ]
    def horizontalLayoutConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.HorizontalLayoutConfiguration.ReadOnly
    ]
    def verticalLayoutConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.VerticalLayoutConfiguration.ReadOnly
    ]
    def videoAttribute
        : Optional[zio.aws.chimesdkmediapipelines.model.VideoAttribute.ReadOnly]
    def canvasOrientation
        : Optional[zio.aws.chimesdkmediapipelines.model.CanvasOrientation]
    def getContentShareLayout: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.ContentShareLayoutOption
    ] = ZIO.succeed(contentShareLayout)
    def getPresenterOnlyConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.PresenterOnlyConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "presenterOnlyConfiguration",
      presenterOnlyConfiguration
    )
    def getActiveSpeakerOnlyConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.ActiveSpeakerOnlyConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activeSpeakerOnlyConfiguration",
      activeSpeakerOnlyConfiguration
    )
    def getHorizontalLayoutConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.HorizontalLayoutConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "horizontalLayoutConfiguration",
      horizontalLayoutConfiguration
    )
    def getVerticalLayoutConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.VerticalLayoutConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "verticalLayoutConfiguration",
      verticalLayoutConfiguration
    )
    def getVideoAttribute: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.VideoAttribute.ReadOnly
    ] = AwsError.unwrapOptionField("videoAttribute", videoAttribute)
    def getCanvasOrientation: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.CanvasOrientation
    ] = AwsError.unwrapOptionField("canvasOrientation", canvasOrientation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GridViewConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.GridViewConfiguration.ReadOnly {
    override val contentShareLayout
        : zio.aws.chimesdkmediapipelines.model.ContentShareLayoutOption =
      zio.aws.chimesdkmediapipelines.model.ContentShareLayoutOption
        .wrap(impl.contentShareLayout())
    override val presenterOnlyConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.PresenterOnlyConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.presenterOnlyConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.PresenterOnlyConfiguration
          .wrap(value)
      )
    override val activeSpeakerOnlyConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.ActiveSpeakerOnlyConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.activeSpeakerOnlyConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.ActiveSpeakerOnlyConfiguration
          .wrap(value)
      )
    override val horizontalLayoutConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.HorizontalLayoutConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.horizontalLayoutConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.HorizontalLayoutConfiguration
          .wrap(value)
      )
    override val verticalLayoutConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.VerticalLayoutConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.verticalLayoutConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.VerticalLayoutConfiguration
          .wrap(value)
      )
    override val videoAttribute: Optional[
      zio.aws.chimesdkmediapipelines.model.VideoAttribute.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.videoAttribute())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.VideoAttribute.wrap(value)
      )
    override val canvasOrientation
        : Optional[zio.aws.chimesdkmediapipelines.model.CanvasOrientation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canvasOrientation())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.CanvasOrientation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GridViewConfiguration
  ): zio.aws.chimesdkmediapipelines.model.GridViewConfiguration.ReadOnly =
    new Wrapper(impl)
}
