package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3RecordingSinkConfiguration(
    destination: Optional[Arn] = Optional.Absent,
    recordingFileFormat: Optional[
      zio.aws.chimesdkmediapipelines.model.RecordingFileFormat
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.S3RecordingSinkConfiguration = {
    import S3RecordingSinkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.S3RecordingSinkConfiguration
      .builder()
      .optionallyWith(
        destination.map(value => Arn.unwrap(value): java.lang.String)
      )(_.destination)
      .optionallyWith(recordingFileFormat.map(value => value.unwrap))(
        _.recordingFileFormat
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.S3RecordingSinkConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.S3RecordingSinkConfiguration
      .wrap(buildAwsValue())
}
object S3RecordingSinkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.S3RecordingSinkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.S3RecordingSinkConfiguration =
      zio.aws.chimesdkmediapipelines.model.S3RecordingSinkConfiguration(
        destination.map(value => value),
        recordingFileFormat.map(value => value)
      )
    def destination: Optional[Arn]
    def recordingFileFormat
        : Optional[zio.aws.chimesdkmediapipelines.model.RecordingFileFormat]
    def getDestination: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("destination", destination)
    def getRecordingFileFormat: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.RecordingFileFormat
    ] = AwsError.unwrapOptionField("recordingFileFormat", recordingFileFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.S3RecordingSinkConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.S3RecordingSinkConfiguration.ReadOnly {
    override val destination: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.destination())
      .map(value => zio.aws.chimesdkmediapipelines.model.primitives.Arn(value))
    override val recordingFileFormat
        : Optional[zio.aws.chimesdkmediapipelines.model.RecordingFileFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordingFileFormat())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.RecordingFileFormat.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.S3RecordingSinkConfiguration
  ): zio.aws.chimesdkmediapipelines.model.S3RecordingSinkConfiguration.ReadOnly =
    new Wrapper(impl)
}
