package zio.aws.chimesdkmediapipelines.model
import scala.jdk.CollectionConverters._
sealed trait RecordingFileFormat {
  def unwrap: software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingFileFormat
}
object RecordingFileFormat {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingFileFormat
  ): zio.aws.chimesdkmediapipelines.model.RecordingFileFormat = value match {
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingFileFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingFileFormat.WAV =>
      val r = Wav
      r
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingFileFormat.OPUS =>
      val r = Opus
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmediapipelines.model.RecordingFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingFileFormat =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingFileFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object Wav
      extends zio.aws.chimesdkmediapipelines.model.RecordingFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingFileFormat =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingFileFormat.WAV
  }
  case object Opus
      extends zio.aws.chimesdkmediapipelines.model.RecordingFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingFileFormat =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingFileFormat.OPUS
  }
}
