package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListMediaPipelineKinesisVideoStreamPoolsResponse(
    kinesisVideoStreamPools: Optional[Iterable[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolSummary
    ]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelineKinesisVideoStreamPoolsResponse = {
    import ListMediaPipelineKinesisVideoStreamPoolsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelineKinesisVideoStreamPoolsResponse
      .builder()
      .optionallyWith(
        kinesisVideoStreamPools.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.kinesisVideoStreamPools)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.ListMediaPipelineKinesisVideoStreamPoolsResponse.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.ListMediaPipelineKinesisVideoStreamPoolsResponse
      .wrap(buildAwsValue())
}
object ListMediaPipelineKinesisVideoStreamPoolsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelineKinesisVideoStreamPoolsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.ListMediaPipelineKinesisVideoStreamPoolsResponse =
      zio.aws.chimesdkmediapipelines.model
        .ListMediaPipelineKinesisVideoStreamPoolsResponse(
          kinesisVideoStreamPools.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def kinesisVideoStreamPools: Optional[List[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolSummary.ReadOnly
    ]]
    def nextToken: Optional[String]
    def getKinesisVideoStreamPools: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "kinesisVideoStreamPools",
      kinesisVideoStreamPools
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelineKinesisVideoStreamPoolsResponse
  ) extends zio.aws.chimesdkmediapipelines.model.ListMediaPipelineKinesisVideoStreamPoolsResponse.ReadOnly {
    override val kinesisVideoStreamPools: Optional[List[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolSummary.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisVideoStreamPools())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolSummary
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelineKinesisVideoStreamPoolsResponse
  ): zio.aws.chimesdkmediapipelines.model.ListMediaPipelineKinesisVideoStreamPoolsResponse.ReadOnly =
    new Wrapper(impl)
}
