package zio.aws.chimesdkmediapipelines.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmediapipelines.model.primitives.DataRetentionChangeInHours
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class KinesisVideoStreamConfigurationUpdate(
    dataRetentionInHours: Optional[DataRetentionChangeInHours] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamConfigurationUpdate = {
    import KinesisVideoStreamConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamConfigurationUpdate
      .builder()
      .optionallyWith(
        dataRetentionInHours.map(value =>
          DataRetentionChangeInHours.unwrap(value): Integer
        )
      )(_.dataRetentionInHours)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfigurationUpdate.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfigurationUpdate
      .wrap(buildAwsValue())
}
object KinesisVideoStreamConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfigurationUpdate =
      zio.aws.chimesdkmediapipelines.model
        .KinesisVideoStreamConfigurationUpdate(
          dataRetentionInHours.map(value => value)
        )
    def dataRetentionInHours: Optional[DataRetentionChangeInHours]
    def getDataRetentionInHours
        : ZIO[Any, AwsError, DataRetentionChangeInHours] =
      AwsError.unwrapOptionField("dataRetentionInHours", dataRetentionInHours)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamConfigurationUpdate
  ) extends zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfigurationUpdate.ReadOnly {
    override val dataRetentionInHours: Optional[DataRetentionChangeInHours] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataRetentionInHours())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .DataRetentionChangeInHours(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamConfigurationUpdate
  ): zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
