package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.ClientRequestToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMediaStreamPipelineRequest(
    sources: Iterable[zio.aws.chimesdkmediapipelines.model.MediaStreamSource],
    sinks: Iterable[zio.aws.chimesdkmediapipelines.model.MediaStreamSink],
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.chimesdkmediapipelines.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaStreamPipelineRequest = {
    import CreateMediaStreamPipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaStreamPipelineRequest
      .builder()
      .sources(sources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .sinks(sinks.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.CreateMediaStreamPipelineRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.CreateMediaStreamPipelineRequest
      .wrap(buildAwsValue())
}
object CreateMediaStreamPipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaStreamPipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.CreateMediaStreamPipelineRequest =
      zio.aws.chimesdkmediapipelines.model.CreateMediaStreamPipelineRequest(
        sources.map { item =>
          item.asEditable
        },
        sinks.map { item =>
          item.asEditable
        },
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sources
        : List[zio.aws.chimesdkmediapipelines.model.MediaStreamSource.ReadOnly]
    def sinks
        : List[zio.aws.chimesdkmediapipelines.model.MediaStreamSink.ReadOnly]
    def clientRequestToken: Optional[ClientRequestToken]
    def tags: Optional[List[zio.aws.chimesdkmediapipelines.model.Tag.ReadOnly]]
    def getSources: ZIO[Any, Nothing, List[
      zio.aws.chimesdkmediapipelines.model.MediaStreamSource.ReadOnly
    ]] = ZIO.succeed(sources)
    def getSinks: ZIO[Any, Nothing, List[
      zio.aws.chimesdkmediapipelines.model.MediaStreamSink.ReadOnly
    ]] = ZIO.succeed(sinks)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmediapipelines.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaStreamPipelineRequest
  ) extends zio.aws.chimesdkmediapipelines.model.CreateMediaStreamPipelineRequest.ReadOnly {
    override val sources: List[
      zio.aws.chimesdkmediapipelines.model.MediaStreamSource.ReadOnly
    ] = impl
      .sources()
      .asScala
      .map { item =>
        zio.aws.chimesdkmediapipelines.model.MediaStreamSource.wrap(item)
      }
      .toList
    override val sinks
        : List[zio.aws.chimesdkmediapipelines.model.MediaStreamSink.ReadOnly] =
      impl
        .sinks()
        .asScala
        .map { item =>
          zio.aws.chimesdkmediapipelines.model.MediaStreamSink.wrap(item)
        }
        .toList
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .ClientRequestToken(value)
        )
    override val tags
        : Optional[List[zio.aws.chimesdkmediapipelines.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkmediapipelines.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaStreamPipelineRequest
  ): zio.aws.chimesdkmediapipelines.model.CreateMediaStreamPipelineRequest.ReadOnly =
    new Wrapper(impl)
}
