package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateMediaPipelineKinesisVideoStreamPoolRequest(
    identifier: NonEmptyString,
    streamConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfigurationUpdate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolRequest = {
    import UpdateMediaPipelineKinesisVideoStreamPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolRequest
      .builder()
      .identifier(NonEmptyString.unwrap(identifier): java.lang.String)
      .optionallyWith(streamConfiguration.map(value => value.buildAwsValue()))(
        _.streamConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolRequest
      .wrap(buildAwsValue())
}
object UpdateMediaPipelineKinesisVideoStreamPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolRequest =
      zio.aws.chimesdkmediapipelines.model
        .UpdateMediaPipelineKinesisVideoStreamPoolRequest(
          identifier,
          streamConfiguration.map(value => value.asEditable)
        )
    def identifier: NonEmptyString
    def streamConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfigurationUpdate.ReadOnly
    ]
    def getIdentifier: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(identifier)
    def getStreamConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("streamConfiguration", streamConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolRequest
  ) extends zio.aws.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolRequest.ReadOnly {
    override val identifier: NonEmptyString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .NonEmptyString(impl.identifier())
    override val streamConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfigurationUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.streamConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfigurationUpdate
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolRequest
  ): zio.aws.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolRequest.ReadOnly =
    new Wrapper(impl)
}
