package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartSpeakerSearchTaskResponse(
    speakerSearchTask: Optional[
      zio.aws.chimesdkmediapipelines.model.SpeakerSearchTask
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.StartSpeakerSearchTaskResponse = {
    import StartSpeakerSearchTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.StartSpeakerSearchTaskResponse
      .builder()
      .optionallyWith(speakerSearchTask.map(value => value.buildAwsValue()))(
        _.speakerSearchTask
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.StartSpeakerSearchTaskResponse.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.StartSpeakerSearchTaskResponse
      .wrap(buildAwsValue())
}
object StartSpeakerSearchTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.StartSpeakerSearchTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.StartSpeakerSearchTaskResponse =
      zio.aws.chimesdkmediapipelines.model.StartSpeakerSearchTaskResponse(
        speakerSearchTask.map(value => value.asEditable)
      )
    def speakerSearchTask: Optional[
      zio.aws.chimesdkmediapipelines.model.SpeakerSearchTask.ReadOnly
    ]
    def getSpeakerSearchTask: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.SpeakerSearchTask.ReadOnly
    ] = AwsError.unwrapOptionField("speakerSearchTask", speakerSearchTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.StartSpeakerSearchTaskResponse
  ) extends zio.aws.chimesdkmediapipelines.model.StartSpeakerSearchTaskResponse.ReadOnly {
    override val speakerSearchTask: Optional[
      zio.aws.chimesdkmediapipelines.model.SpeakerSearchTask.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.speakerSearchTask())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.SpeakerSearchTask.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.StartSpeakerSearchTaskResponse
  ): zio.aws.chimesdkmediapipelines.model.StartSpeakerSearchTaskResponse.ReadOnly =
    new Wrapper(impl)
}
