package zio.aws.chimesdkmediapipelines.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmediapipelines.model.primitives.{
  Iso8601Timestamp,
  AmazonResourceName,
  GuidString
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class MediaConcatenationPipeline(
    mediaPipelineId: Optional[GuidString] = Optional.Absent,
    mediaPipelineArn: Optional[AmazonResourceName] = Optional.Absent,
    sources: Optional[
      Iterable[zio.aws.chimesdkmediapipelines.model.ConcatenationSource]
    ] = Optional.Absent,
    sinks: Optional[
      Iterable[zio.aws.chimesdkmediapipelines.model.ConcatenationSink]
    ] = Optional.Absent,
    status: Optional[zio.aws.chimesdkmediapipelines.model.MediaPipelineStatus] =
      Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaConcatenationPipeline = {
    import MediaConcatenationPipeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaConcatenationPipeline
      .builder()
      .optionallyWith(
        mediaPipelineId.map(value => GuidString.unwrap(value): java.lang.String)
      )(_.mediaPipelineId)
      .optionallyWith(
        mediaPipelineArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.mediaPipelineArn)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .optionallyWith(
        sinks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sinks)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.MediaConcatenationPipeline.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.MediaConcatenationPipeline
      .wrap(buildAwsValue())
}
object MediaConcatenationPipeline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaConcatenationPipeline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.MediaConcatenationPipeline =
      zio.aws.chimesdkmediapipelines.model.MediaConcatenationPipeline(
        mediaPipelineId.map(value => value),
        mediaPipelineArn.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sinks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value)
      )
    def mediaPipelineId: Optional[GuidString]
    def mediaPipelineArn: Optional[AmazonResourceName]
    def sources: Optional[
      List[zio.aws.chimesdkmediapipelines.model.ConcatenationSource.ReadOnly]
    ]
    def sinks: Optional[
      List[zio.aws.chimesdkmediapipelines.model.ConcatenationSink.ReadOnly]
    ]
    def status
        : Optional[zio.aws.chimesdkmediapipelines.model.MediaPipelineStatus]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def getMediaPipelineId: ZIO[Any, AwsError, GuidString] =
      AwsError.unwrapOptionField("mediaPipelineId", mediaPipelineId)
    def getMediaPipelineArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("mediaPipelineArn", mediaPipelineArn)
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmediapipelines.model.ConcatenationSource.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
    def getSinks: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmediapipelines.model.ConcatenationSink.ReadOnly
    ]] = AwsError.unwrapOptionField("sinks", sinks)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaPipelineStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaConcatenationPipeline
  ) extends zio.aws.chimesdkmediapipelines.model.MediaConcatenationPipeline.ReadOnly {
    override val mediaPipelineId: Optional[GuidString] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaPipelineId())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.primitives.GuidString(value)
      )
    override val mediaPipelineArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaPipelineArn())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .AmazonResourceName(value)
        )
    override val sources: Optional[
      List[zio.aws.chimesdkmediapipelines.model.ConcatenationSource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmediapipelines.model.ConcatenationSource.wrap(item)
        }.toList
      )
    override val sinks: Optional[
      List[zio.aws.chimesdkmediapipelines.model.ConcatenationSink.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sinks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmediapipelines.model.ConcatenationSink.wrap(item)
        }.toList
      )
    override val status
        : Optional[zio.aws.chimesdkmediapipelines.model.MediaPipelineStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.MediaPipelineStatus.wrap(value)
        )
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .Iso8601Timestamp(value)
        )
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .Iso8601Timestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaConcatenationPipeline
  ): zio.aws.chimesdkmediapipelines.model.MediaConcatenationPipeline.ReadOnly =
    new Wrapper(impl)
}
