package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetMediaPipelineKinesisVideoStreamPoolResponse(
    kinesisVideoStreamPoolConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolResponse = {
    import GetMediaPipelineKinesisVideoStreamPoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolResponse
      .builder()
      .optionallyWith(
        kinesisVideoStreamPoolConfiguration.map(value => value.buildAwsValue())
      )(_.kinesisVideoStreamPoolConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolResponse.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolResponse
      .wrap(buildAwsValue())
}
object GetMediaPipelineKinesisVideoStreamPoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolResponse =
      zio.aws.chimesdkmediapipelines.model
        .GetMediaPipelineKinesisVideoStreamPoolResponse(
          kinesisVideoStreamPoolConfiguration.map(value => value.asEditable)
        )
    def kinesisVideoStreamPoolConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration.ReadOnly
    ]
    def getKinesisVideoStreamPoolConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisVideoStreamPoolConfiguration",
      kinesisVideoStreamPoolConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolResponse
  ) extends zio.aws.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolResponse.ReadOnly {
    override val kinesisVideoStreamPoolConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisVideoStreamPoolConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolResponse
  ): zio.aws.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolResponse.ReadOnly =
    new Wrapper(impl)
}
