package zio.aws.chimesdkmediapipelines.model
import scala.jdk.CollectionConverters._
sealed trait MediaStreamType {
  def unwrap: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamType
}
object MediaStreamType {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamType
  ): zio.aws.chimesdkmediapipelines.model.MediaStreamType = value match {
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamType.MIXED_AUDIO =>
      val r = MixedAudio
      r
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamType.INDIVIDUAL_AUDIO =>
      val r = IndividualAudio
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmediapipelines.model.MediaStreamType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamType.UNKNOWN_TO_SDK_VERSION
  }
  case object MixedAudio
      extends zio.aws.chimesdkmediapipelines.model.MediaStreamType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamType.MIXED_AUDIO
  }
  case object IndividualAudio
      extends zio.aws.chimesdkmediapipelines.model.MediaStreamType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamType.INDIVIDUAL_AUDIO
  }
}
