package zio.aws.chimesdkmediapipelines.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmediapipelines.model.primitives.{
  KinesisVideoStreamPoolName,
  Arn,
  KinesisVideoStreamPoolSize,
  KinesisVideoStreamPoolId,
  Iso8601Timestamp
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class KinesisVideoStreamPoolConfiguration(
    poolArn: Optional[Arn] = Optional.Absent,
    poolName: Optional[KinesisVideoStreamPoolName] = Optional.Absent,
    poolId: Optional[KinesisVideoStreamPoolId] = Optional.Absent,
    poolStatus: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolStatus
    ] = Optional.Absent,
    poolSize: Optional[KinesisVideoStreamPoolSize] = Optional.Absent,
    streamConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration
    ] = Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration = {
    import KinesisVideoStreamPoolConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration
      .builder()
      .optionallyWith(
        poolArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.poolArn)
      .optionallyWith(
        poolName.map(value =>
          KinesisVideoStreamPoolName.unwrap(value): java.lang.String
        )
      )(_.poolName)
      .optionallyWith(
        poolId.map(value =>
          KinesisVideoStreamPoolId.unwrap(value): java.lang.String
        )
      )(_.poolId)
      .optionallyWith(poolStatus.map(value => value.unwrap))(_.poolStatus)
      .optionallyWith(
        poolSize.map(value => KinesisVideoStreamPoolSize.unwrap(value): Integer)
      )(_.poolSize)
      .optionallyWith(streamConfiguration.map(value => value.buildAwsValue()))(
        _.streamConfiguration
      )
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration
      .wrap(buildAwsValue())
}
object KinesisVideoStreamPoolConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration =
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration(
        poolArn.map(value => value),
        poolName.map(value => value),
        poolId.map(value => value),
        poolStatus.map(value => value),
        poolSize.map(value => value),
        streamConfiguration.map(value => value.asEditable),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value)
      )
    def poolArn: Optional[Arn]
    def poolName: Optional[KinesisVideoStreamPoolName]
    def poolId: Optional[KinesisVideoStreamPoolId]
    def poolStatus: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolStatus
    ]
    def poolSize: Optional[KinesisVideoStreamPoolSize]
    def streamConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration.ReadOnly
    ]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def getPoolArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("poolArn", poolArn)
    def getPoolName: ZIO[Any, AwsError, KinesisVideoStreamPoolName] =
      AwsError.unwrapOptionField("poolName", poolName)
    def getPoolId: ZIO[Any, AwsError, KinesisVideoStreamPoolId] =
      AwsError.unwrapOptionField("poolId", poolId)
    def getPoolStatus: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolStatus
    ] = AwsError.unwrapOptionField("poolStatus", poolStatus)
    def getPoolSize: ZIO[Any, AwsError, KinesisVideoStreamPoolSize] =
      AwsError.unwrapOptionField("poolSize", poolSize)
    def getStreamConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("streamConfiguration", streamConfiguration)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration.ReadOnly {
    override val poolArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.poolArn())
      .map(value => zio.aws.chimesdkmediapipelines.model.primitives.Arn(value))
    override val poolName: Optional[KinesisVideoStreamPoolName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.poolName())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .KinesisVideoStreamPoolName(value)
        )
    override val poolId: Optional[KinesisVideoStreamPoolId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.poolId())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .KinesisVideoStreamPoolId(value)
        )
    override val poolStatus: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.poolStatus())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolStatus
          .wrap(value)
      )
    override val poolSize: Optional[KinesisVideoStreamPoolSize] =
      zio.aws.core.internal
        .optionalFromNullable(impl.poolSize())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .KinesisVideoStreamPoolSize(value)
        )
    override val streamConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.streamConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration
          .wrap(value)
      )
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .Iso8601Timestamp(value)
        )
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .Iso8601Timestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration
  ): zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration.ReadOnly =
    new Wrapper(impl)
}
