package zio.aws.chimesdkmediapipelines
import zio.aws.chimesdkmediapipelines.model.ListMediaPipelinesResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.chimesdkmediapipelines.{
  ChimeSdkMediaPipelinesAsyncClientBuilder,
  ChimeSdkMediaPipelinesAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.aws.chimesdkmediapipelines.model.{
  GetMediaPipelineRequest,
  ListMediaPipelinesRequest,
  CreateMediaInsightsPipelineConfigurationRequest,
  GetMediaCapturePipelineRequest,
  ListMediaCapturePipelinesRequest,
  ListMediaInsightsPipelineConfigurationsRequest,
  ListTagsForResourceRequest,
  GetMediaInsightsPipelineConfigurationRequest,
  CreateMediaLiveConnectorPipelineRequest,
  DeleteMediaCapturePipelineRequest,
  CreateMediaCapturePipelineRequest,
  DeleteMediaInsightsPipelineConfigurationRequest,
  UntagResourceRequest,
  DeleteMediaPipelineRequest,
  CreateMediaInsightsPipelineRequest,
  CreateMediaConcatenationPipelineRequest,
  UpdateMediaInsightsPipelineStatusRequest,
  TagResourceRequest,
  UpdateMediaInsightsPipelineConfigurationRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.chimesdkmediapipelines.model.{
  UpdateMediaInsightsPipelineStatusResponse,
  DeleteMediaPipelineResponse,
  CreateMediaInsightsPipelineConfigurationResponse,
  MediaCapturePipelineSummary,
  CreateMediaConcatenationPipelineResponse,
  CreateMediaCapturePipelineResponse,
  ListMediaInsightsPipelineConfigurationsResponse,
  GetMediaPipelineResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DeleteMediaCapturePipelineResponse,
  GetMediaInsightsPipelineConfigurationResponse,
  DeleteMediaInsightsPipelineConfigurationResponse,
  MediaPipelineSummary,
  GetMediaCapturePipelineResponse,
  MediaInsightsPipelineConfigurationSummary,
  CreateMediaInsightsPipelineResponse,
  ListMediaCapturePipelinesResponse,
  TagResourceResponse,
  UpdateMediaInsightsPipelineConfigurationResponse,
  ListMediaPipelinesResponse,
  CreateMediaLiveConnectorPipelineResponse
}
import scala.jdk.CollectionConverters._
trait ChimeSdkMediaPipelines extends AspectSupport[ChimeSdkMediaPipelines] {
  val api: ChimeSdkMediaPipelinesAsyncClient
  def deleteMediaPipeline(
      request: DeleteMediaPipelineRequest
  ): IO[AwsError, Unit]
  def getMediaInsightsPipelineConfiguration(
      request: GetMediaInsightsPipelineConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.GetMediaInsightsPipelineConfigurationResponse.ReadOnly
  ]
  def createMediaInsightsPipeline(
      request: CreateMediaInsightsPipelineRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineResponse.ReadOnly
  ]
  def getMediaCapturePipeline(request: GetMediaCapturePipelineRequest): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse.ReadOnly
  ]
  def createMediaInsightsPipelineConfiguration(
      request: CreateMediaInsightsPipelineConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationResponse.ReadOnly
  ]
  def deleteMediaInsightsPipelineConfiguration(
      request: DeleteMediaInsightsPipelineConfigurationRequest
  ): IO[AwsError, Unit]
  def listMediaInsightsPipelineConfigurations(
      request: ListMediaInsightsPipelineConfigurationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary.ReadOnly
  ]
  def listMediaInsightsPipelineConfigurationsPaginated(
      request: ListMediaInsightsPipelineConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse.ReadOnly
  ]
  def getMediaPipeline(request: GetMediaPipelineRequest): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.GetMediaPipelineResponse.ReadOnly
  ]
  def listMediaPipelines(request: ListMediaPipelinesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary.ReadOnly
  ]
  def listMediaPipelinesPaginated(
      request: ListMediaPipelinesRequest
  ): IO[AwsError, ReadOnly]
  def untagResource(request: UntagResourceRequest): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.UntagResourceResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.TagResourceResponse.ReadOnly
  ]
  def createMediaConcatenationPipeline(
      request: CreateMediaConcatenationPipelineRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse.ReadOnly
  ]
  def createMediaLiveConnectorPipeline(
      request: CreateMediaLiveConnectorPipelineRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse.ReadOnly
  ]
  def createMediaCapturePipeline(
      request: CreateMediaCapturePipelineRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse.ReadOnly
  ]
  def updateMediaInsightsPipelineConfiguration(
      request: UpdateMediaInsightsPipelineConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationResponse.ReadOnly
  ]
  def deleteMediaCapturePipeline(
      request: DeleteMediaCapturePipelineRequest
  ): IO[AwsError, Unit]
  def listMediaCapturePipelines(
      request: ListMediaCapturePipelinesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSummary.ReadOnly
  ]
  def listMediaCapturePipelinesPaginated(
      request: ListMediaCapturePipelinesRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse.ReadOnly
  ]
  def updateMediaInsightsPipelineStatus(
      request: UpdateMediaInsightsPipelineStatusRequest
  ): IO[AwsError, Unit]
}
object ChimeSdkMediaPipelines {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ChimeSdkMediaPipelines] =
    customized(identity)
  def customized(
      customization: ChimeSdkMediaPipelinesAsyncClientBuilder => ChimeSdkMediaPipelinesAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ChimeSdkMediaPipelines] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ChimeSdkMediaPipelinesAsyncClientBuilder => ChimeSdkMediaPipelinesAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ChimeSdkMediaPipelines] =
    for (
      awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
      builder = ChimeSdkMediaPipelinesAsyncClient
        .builder()
        .asyncConfiguration(
          software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
            .builder()
            .advancedOption(
              software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
              executor.asJava
            )
            .build()
        );
      b0 <- awsConfig.configure[
        ChimeSdkMediaPipelinesAsyncClient,
        ChimeSdkMediaPipelinesAsyncClientBuilder
      ](builder);
      b1 <- awsConfig.configureHttpClient[
        ChimeSdkMediaPipelinesAsyncClient,
        ChimeSdkMediaPipelinesAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
    )
      yield new ChimeSdkMediaPipelinesImpl(
        client,
        AwsCallAspect.identity,
        ZEnvironment.empty
      )
  private class ChimeSdkMediaPipelinesImpl[R](
      override val api: ChimeSdkMediaPipelinesAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ChimeSdkMediaPipelines
      with AwsServiceBase[R] {
    override val serviceName: String = "ChimeSdkMediaPipelines"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ChimeSdkMediaPipelinesImpl[R1] =
      new ChimeSdkMediaPipelinesImpl(api, newAspect, r)
    def deleteMediaPipeline(
        request: DeleteMediaPipelineRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineRequest,
      DeleteMediaPipelineResponse
    ]("deleteMediaPipeline", api.deleteMediaPipeline)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getMediaInsightsPipelineConfiguration(
        request: GetMediaInsightsPipelineConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.GetMediaInsightsPipelineConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaInsightsPipelineConfigurationRequest,
      GetMediaInsightsPipelineConfigurationResponse
    ](
      "getMediaInsightsPipelineConfiguration",
      api.getMediaInsightsPipelineConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkmediapipelines.model.GetMediaInsightsPipelineConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def createMediaInsightsPipeline(
        request: CreateMediaInsightsPipelineRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineRequest,
      CreateMediaInsightsPipelineResponse
    ]("createMediaInsightsPipeline", api.createMediaInsightsPipeline)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineResponse.wrap
    ).provideEnvironment(r)
    def getMediaCapturePipeline(request: GetMediaCapturePipelineRequest): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaCapturePipelineRequest,
      GetMediaCapturePipelineResponse
    ]("getMediaCapturePipeline", api.getMediaCapturePipeline)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse.wrap
    ).provideEnvironment(r)
    def createMediaInsightsPipelineConfiguration(
        request: CreateMediaInsightsPipelineConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationRequest,
      CreateMediaInsightsPipelineConfigurationResponse
    ](
      "createMediaInsightsPipelineConfiguration",
      api.createMediaInsightsPipelineConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def deleteMediaInsightsPipelineConfiguration(
        request: DeleteMediaInsightsPipelineConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaInsightsPipelineConfigurationRequest,
      DeleteMediaInsightsPipelineConfigurationResponse
    ](
      "deleteMediaInsightsPipelineConfiguration",
      api.deleteMediaInsightsPipelineConfiguration
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listMediaInsightsPipelineConfigurations(
        request: ListMediaInsightsPipelineConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsRequest,
      ListMediaInsightsPipelineConfigurationsResponse,
      MediaInsightsPipelineConfigurationSummary
    ](
      "listMediaInsightsPipelineConfigurations",
      api.listMediaInsightsPipelineConfigurations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(r.mediaInsightsPipelineConfigurations().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary
          .wrap(item)
      )
      .provideEnvironment(r)
    def listMediaInsightsPipelineConfigurationsPaginated(
        request: ListMediaInsightsPipelineConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsRequest,
      ListMediaInsightsPipelineConfigurationsResponse
    ](
      "listMediaInsightsPipelineConfigurations",
      api.listMediaInsightsPipelineConfigurations
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse.wrap
      )
      .provideEnvironment(r)
    def getMediaPipeline(request: GetMediaPipelineRequest): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.GetMediaPipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineRequest,
      GetMediaPipelineResponse
    ]("getMediaPipeline", api.getMediaPipeline)(request.buildAwsValue())
      .map(zio.aws.chimesdkmediapipelines.model.GetMediaPipelineResponse.wrap)
      .provideEnvironment(r)
    def listMediaPipelines(request: ListMediaPipelinesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesRequest,
      ListMediaPipelinesResponse,
      MediaPipelineSummary
    ](
      "listMediaPipelines",
      api.listMediaPipelines,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.mediaPipelines().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listMediaPipelinesPaginated(
        request: ListMediaPipelinesRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesRequest,
      ListMediaPipelinesResponse
    ]("listMediaPipelines", api.listMediaPipelines)(request.buildAwsValue())
      .map(zio.aws.chimesdkmediapipelines.model.ListMediaPipelinesResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.chimesdkmediapipelines.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(
        zio.aws.chimesdkmediapipelines.model.ListTagsForResourceResponse.wrap
      )
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.chimesdkmediapipelines.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def createMediaConcatenationPipeline(
        request: CreateMediaConcatenationPipelineRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineRequest,
      CreateMediaConcatenationPipelineResponse
    ]("createMediaConcatenationPipeline", api.createMediaConcatenationPipeline)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse.wrap
    ).provideEnvironment(r)
    def createMediaLiveConnectorPipeline(
        request: CreateMediaLiveConnectorPipelineRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineRequest,
      CreateMediaLiveConnectorPipelineResponse
    ]("createMediaLiveConnectorPipeline", api.createMediaLiveConnectorPipeline)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse.wrap
    ).provideEnvironment(r)
    def createMediaCapturePipeline(
        request: CreateMediaCapturePipelineRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineRequest,
      CreateMediaCapturePipelineResponse
    ]("createMediaCapturePipeline", api.createMediaCapturePipeline)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse.wrap
    ).provideEnvironment(r)
    def updateMediaInsightsPipelineConfiguration(
        request: UpdateMediaInsightsPipelineConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationRequest,
      UpdateMediaInsightsPipelineConfigurationResponse
    ](
      "updateMediaInsightsPipelineConfiguration",
      api.updateMediaInsightsPipelineConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def deleteMediaCapturePipeline(
        request: DeleteMediaCapturePipelineRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaCapturePipelineRequest,
      DeleteMediaCapturePipelineResponse
    ]("deleteMediaCapturePipeline", api.deleteMediaCapturePipeline)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listMediaCapturePipelines(
        request: ListMediaCapturePipelinesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesRequest,
      ListMediaCapturePipelinesResponse,
      MediaCapturePipelineSummary
    ](
      "listMediaCapturePipelines",
      api.listMediaCapturePipelines,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.mediaCapturePipelines().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSummary
          .wrap(item)
      )
      .provideEnvironment(r)
    def listMediaCapturePipelinesPaginated(
        request: ListMediaCapturePipelinesRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesRequest,
      ListMediaCapturePipelinesResponse
    ]("listMediaCapturePipelines", api.listMediaCapturePipelines)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse.wrap
    ).provideEnvironment(r)
    def updateMediaInsightsPipelineStatus(
        request: UpdateMediaInsightsPipelineStatusRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineStatusRequest,
      UpdateMediaInsightsPipelineStatusResponse
    ](
      "updateMediaInsightsPipelineStatus",
      api.updateMediaInsightsPipelineStatus
    )(request.buildAwsValue()).unit.provideEnvironment(r)
  }
  def deleteMediaPipeline(request: DeleteMediaPipelineRequest): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.deleteMediaPipeline(request))
  def getMediaInsightsPipelineConfiguration(
      request: GetMediaInsightsPipelineConfigurationRequest
  ): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.GetMediaInsightsPipelineConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMediaInsightsPipelineConfiguration(request))
  def createMediaInsightsPipeline(
      request: CreateMediaInsightsPipelineRequest
  ): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMediaInsightsPipeline(request))
  def getMediaCapturePipeline(request: GetMediaCapturePipelineRequest): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMediaCapturePipeline(request))
  def createMediaInsightsPipelineConfiguration(
      request: CreateMediaInsightsPipelineConfigurationRequest
  ): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMediaInsightsPipelineConfiguration(request))
  def deleteMediaInsightsPipelineConfiguration(
      request: DeleteMediaInsightsPipelineConfigurationRequest
  ): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.deleteMediaInsightsPipelineConfiguration(request))
  def listMediaInsightsPipelineConfigurations(
      request: ListMediaInsightsPipelineConfigurationsRequest
  ): ZStream[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary.ReadOnly
  ] = ZStream.serviceWithStream(
    _.listMediaInsightsPipelineConfigurations(request)
  )
  def listMediaInsightsPipelineConfigurationsPaginated(
      request: ListMediaInsightsPipelineConfigurationsRequest
  ): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listMediaInsightsPipelineConfigurationsPaginated(request)
  )
  def getMediaPipeline(request: GetMediaPipelineRequest): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.GetMediaPipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMediaPipeline(request))
  def listMediaPipelines(request: ListMediaPipelinesRequest): ZStream[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listMediaPipelines(request))
  def listMediaPipelinesPaginated(request: ListMediaPipelinesRequest): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    ReadOnly
  ] = ZIO.serviceWithZIO(_.listMediaPipelinesPaginated(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def createMediaConcatenationPipeline(
      request: CreateMediaConcatenationPipelineRequest
  ): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMediaConcatenationPipeline(request))
  def createMediaLiveConnectorPipeline(
      request: CreateMediaLiveConnectorPipelineRequest
  ): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMediaLiveConnectorPipeline(request))
  def createMediaCapturePipeline(
      request: CreateMediaCapturePipelineRequest
  ): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMediaCapturePipeline(request))
  def updateMediaInsightsPipelineConfiguration(
      request: UpdateMediaInsightsPipelineConfigurationRequest
  ): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMediaInsightsPipelineConfiguration(request))
  def deleteMediaCapturePipeline(
      request: DeleteMediaCapturePipelineRequest
  ): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.deleteMediaCapturePipeline(request))
  def listMediaCapturePipelines(
      request: ListMediaCapturePipelinesRequest
  ): ZStream[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listMediaCapturePipelines(request))
  def listMediaCapturePipelinesPaginated(
      request: ListMediaCapturePipelinesRequest
  ): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMediaCapturePipelinesPaginated(request))
  def updateMediaInsightsPipelineStatus(
      request: UpdateMediaInsightsPipelineStatusRequest
  ): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.updateMediaInsightsPipelineStatus(request))
}
