package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class KinesisVideoStreamRecordingSourceRuntimeConfiguration(
    streams: Iterable[
      zio.aws.chimesdkmediapipelines.model.RecordingStreamConfiguration
    ],
    fragmentSelector: zio.aws.chimesdkmediapipelines.model.FragmentSelector
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration = {
    import KinesisVideoStreamRecordingSourceRuntimeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration
      .builder()
      .streams(streams.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .fragmentSelector(fragmentSelector.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration
      .wrap(buildAwsValue())
}
object KinesisVideoStreamRecordingSourceRuntimeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .KinesisVideoStreamRecordingSourceRuntimeConfiguration(
          streams.map { item =>
            item.asEditable
          },
          fragmentSelector.asEditable
        )
    def streams: List[
      zio.aws.chimesdkmediapipelines.model.RecordingStreamConfiguration.ReadOnly
    ]
    def fragmentSelector
        : zio.aws.chimesdkmediapipelines.model.FragmentSelector.ReadOnly
    def getStreams: ZIO[Any, Nothing, List[
      zio.aws.chimesdkmediapipelines.model.RecordingStreamConfiguration.ReadOnly
    ]] = ZIO.succeed(streams)
    def getFragmentSelector: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.FragmentSelector.ReadOnly
    ] = ZIO.succeed(fragmentSelector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration.ReadOnly {
    override val streams: List[
      zio.aws.chimesdkmediapipelines.model.RecordingStreamConfiguration.ReadOnly
    ] = impl
      .streams()
      .asScala
      .map { item =>
        zio.aws.chimesdkmediapipelines.model.RecordingStreamConfiguration
          .wrap(item)
      }
      .toList
    override val fragmentSelector
        : zio.aws.chimesdkmediapipelines.model.FragmentSelector.ReadOnly =
      zio.aws.chimesdkmediapipelines.model.FragmentSelector
        .wrap(impl.fragmentSelector())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration
  ): zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration.ReadOnly =
    new Wrapper(impl)
}
