package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChimeSdkMeetingConfiguration(
    sourceConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.SourceConfiguration
    ] = Optional.Absent,
    artifactsConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.ArtifactsConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration = {
    import ChimeSdkMeetingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration
      .builder()
      .optionallyWith(sourceConfiguration.map(value => value.buildAwsValue()))(
        _.sourceConfiguration
      )
      .optionallyWith(
        artifactsConfiguration.map(value => value.buildAwsValue())
      )(_.artifactsConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration
      .wrap(buildAwsValue())
}
object ChimeSdkMeetingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration =
      zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration(
        sourceConfiguration.map(value => value.asEditable),
        artifactsConfiguration.map(value => value.asEditable)
      )
    def sourceConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.SourceConfiguration.ReadOnly
    ]
    def artifactsConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.ArtifactsConfiguration.ReadOnly
    ]
    def getSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.SourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("sourceConfiguration", sourceConfiguration)
    def getArtifactsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.ArtifactsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "artifactsConfiguration",
      artifactsConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration.ReadOnly {
    override val sourceConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.SourceConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.SourceConfiguration.wrap(value)
      )
    override val artifactsConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.ArtifactsConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.artifactsConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.ArtifactsConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration
  ): zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration.ReadOnly =
    new Wrapper(impl)
}
