package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class FragmentSelector(
    fragmentSelectorType: zio.aws.chimesdkmediapipelines.model.FragmentSelectorType,
    timestampRange: zio.aws.chimesdkmediapipelines.model.TimestampRange
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.FragmentSelector = {
    import FragmentSelector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.FragmentSelector
      .builder()
      .fragmentSelectorType(fragmentSelectorType.unwrap)
      .timestampRange(timestampRange.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.FragmentSelector.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.FragmentSelector.wrap(buildAwsValue())
}
object FragmentSelector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.FragmentSelector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmediapipelines.model.FragmentSelector =
      zio.aws.chimesdkmediapipelines.model
        .FragmentSelector(fragmentSelectorType, timestampRange.asEditable)
    def fragmentSelectorType
        : zio.aws.chimesdkmediapipelines.model.FragmentSelectorType
    def timestampRange
        : zio.aws.chimesdkmediapipelines.model.TimestampRange.ReadOnly
    def getFragmentSelectorType: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.FragmentSelectorType
    ] = ZIO.succeed(fragmentSelectorType)
    def getTimestampRange: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.TimestampRange.ReadOnly
    ] = ZIO.succeed(timestampRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.FragmentSelector
  ) extends zio.aws.chimesdkmediapipelines.model.FragmentSelector.ReadOnly {
    override val fragmentSelectorType
        : zio.aws.chimesdkmediapipelines.model.FragmentSelectorType =
      zio.aws.chimesdkmediapipelines.model.FragmentSelectorType
        .wrap(impl.fragmentSelectorType())
    override val timestampRange
        : zio.aws.chimesdkmediapipelines.model.TimestampRange.ReadOnly =
      zio.aws.chimesdkmediapipelines.model.TimestampRange
        .wrap(impl.timestampRange())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.FragmentSelector
  ): zio.aws.chimesdkmediapipelines.model.FragmentSelector.ReadOnly =
    new Wrapper(impl)
}
