package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VideoArtifactsConfiguration(
    state: zio.aws.chimesdkmediapipelines.model.ArtifactsState,
    muxType: Optional[zio.aws.chimesdkmediapipelines.model.VideoMuxType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.VideoArtifactsConfiguration = {
    import VideoArtifactsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.VideoArtifactsConfiguration
      .builder()
      .state(state.unwrap)
      .optionallyWith(muxType.map(value => value.unwrap))(_.muxType)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.VideoArtifactsConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.VideoArtifactsConfiguration
      .wrap(buildAwsValue())
}
object VideoArtifactsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.VideoArtifactsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.VideoArtifactsConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .VideoArtifactsConfiguration(state, muxType.map(value => value))
    def state: zio.aws.chimesdkmediapipelines.model.ArtifactsState
    def muxType: Optional[zio.aws.chimesdkmediapipelines.model.VideoMuxType]
    def getState: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.ArtifactsState
    ] = ZIO.succeed(state)
    def getMuxType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.VideoMuxType
    ] = AwsError.unwrapOptionField("muxType", muxType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.VideoArtifactsConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.VideoArtifactsConfiguration.ReadOnly {
    override val state: zio.aws.chimesdkmediapipelines.model.ArtifactsState =
      zio.aws.chimesdkmediapipelines.model.ArtifactsState.wrap(impl.state())
    override val muxType
        : Optional[zio.aws.chimesdkmediapipelines.model.VideoMuxType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.muxType())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.VideoMuxType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.VideoArtifactsConfiguration
  ): zio.aws.chimesdkmediapipelines.model.VideoArtifactsConfiguration.ReadOnly =
    new Wrapper(impl)
}
