package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListMediaInsightsPipelineConfigurationsResponse(
    mediaInsightsPipelineConfigurations: Optional[Iterable[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary
    ]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse = {
    import ListMediaInsightsPipelineConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse
      .builder()
      .optionallyWith(
        mediaInsightsPipelineConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mediaInsightsPipelineConfigurations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListMediaInsightsPipelineConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse =
      zio.aws.chimesdkmediapipelines.model
        .ListMediaInsightsPipelineConfigurationsResponse(
          mediaInsightsPipelineConfigurations.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def mediaInsightsPipelineConfigurations: Optional[List[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary.ReadOnly
    ]]
    def nextToken: Optional[String]
    def getMediaInsightsPipelineConfigurations: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "mediaInsightsPipelineConfigurations",
      mediaInsightsPipelineConfigurations
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse
  ) extends zio.aws.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse.ReadOnly {
    override val mediaInsightsPipelineConfigurations: Optional[List[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaInsightsPipelineConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse
  ): zio.aws.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
