package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{
  ClientRequestToken,
  NonEmptyString,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMediaInsightsPipelineRequest(
    mediaInsightsPipelineConfigurationArn: Arn,
    kinesisVideoStreamSourceRuntimeConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration
    ] = Optional.Absent,
    mediaInsightsRuntimeMetadata: Optional[Map[NonEmptyString, String]] =
      Optional.Absent,
    kinesisVideoStreamRecordingSourceRuntimeConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration
    ] = Optional.Absent,
    s3RecordingSinkRuntimeConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.chimesdkmediapipelines.model.Tag]] =
      Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineRequest = {
    import CreateMediaInsightsPipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineRequest
      .builder()
      .mediaInsightsPipelineConfigurationArn(
        Arn.unwrap(mediaInsightsPipelineConfigurationArn): java.lang.String
      )
      .optionallyWith(
        kinesisVideoStreamSourceRuntimeConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.kinesisVideoStreamSourceRuntimeConfiguration)
      .optionallyWith(
        mediaInsightsRuntimeMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(
                key
              ): java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.mediaInsightsRuntimeMetadata)
      .optionallyWith(
        kinesisVideoStreamRecordingSourceRuntimeConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.kinesisVideoStreamRecordingSourceRuntimeConfiguration)
      .optionallyWith(
        s3RecordingSinkRuntimeConfiguration.map(value => value.buildAwsValue())
      )(_.s3RecordingSinkRuntimeConfiguration)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineRequest
      .wrap(buildAwsValue())
}
object CreateMediaInsightsPipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineRequest =
      zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineRequest(
        mediaInsightsPipelineConfigurationArn,
        kinesisVideoStreamSourceRuntimeConfiguration.map(value =>
          value.asEditable
        ),
        mediaInsightsRuntimeMetadata.map(value => value),
        kinesisVideoStreamRecordingSourceRuntimeConfiguration.map(value =>
          value.asEditable
        ),
        s3RecordingSinkRuntimeConfiguration.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken.map(value => value)
      )
    def mediaInsightsPipelineConfigurationArn: Arn
    def kinesisVideoStreamSourceRuntimeConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration.ReadOnly
    ]
    def mediaInsightsRuntimeMetadata: Optional[Map[NonEmptyString, String]]
    def kinesisVideoStreamRecordingSourceRuntimeConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration.ReadOnly
    ]
    def s3RecordingSinkRuntimeConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration.ReadOnly
    ]
    def tags: Optional[List[zio.aws.chimesdkmediapipelines.model.Tag.ReadOnly]]
    def clientRequestToken: Optional[ClientRequestToken]
    def getMediaInsightsPipelineConfigurationArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(mediaInsightsPipelineConfigurationArn)
    def getKinesisVideoStreamSourceRuntimeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisVideoStreamSourceRuntimeConfiguration",
      kinesisVideoStreamSourceRuntimeConfiguration
    )
    def getMediaInsightsRuntimeMetadata
        : ZIO[Any, AwsError, Map[NonEmptyString, String]] =
      AwsError.unwrapOptionField(
        "mediaInsightsRuntimeMetadata",
        mediaInsightsRuntimeMetadata
      )
    def getKinesisVideoStreamRecordingSourceRuntimeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisVideoStreamRecordingSourceRuntimeConfiguration",
      kinesisVideoStreamRecordingSourceRuntimeConfiguration
    )
    def getS3RecordingSinkRuntimeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3RecordingSinkRuntimeConfiguration",
      s3RecordingSinkRuntimeConfiguration
    )
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmediapipelines.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineRequest
  ) extends zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineRequest.ReadOnly {
    override val mediaInsightsPipelineConfigurationArn: Arn =
      zio.aws.chimesdkmediapipelines.model.primitives
        .Arn(impl.mediaInsightsPipelineConfigurationArn())
    override val kinesisVideoStreamSourceRuntimeConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisVideoStreamSourceRuntimeConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration
          .wrap(value)
      )
    override val mediaInsightsRuntimeMetadata
        : Optional[Map[NonEmptyString, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaInsightsRuntimeMetadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.chimesdkmediapipelines.model.primitives
              .NonEmptyString(key) -> (value: String)
          })
          .toMap
      )
    override val kinesisVideoStreamRecordingSourceRuntimeConfiguration
        : Optional[
          zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration.ReadOnly
        ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.kinesisVideoStreamRecordingSourceRuntimeConfiguration()
      )
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration
          .wrap(value)
      )
    override val s3RecordingSinkRuntimeConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3RecordingSinkRuntimeConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration
          .wrap(value)
      )
    override val tags
        : Optional[List[zio.aws.chimesdkmediapipelines.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkmediapipelines.model.Tag.wrap(item)
          }.toList
        )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineRequest
  ): zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineRequest.ReadOnly =
    new Wrapper(impl)
}
