package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{ClientRequestToken, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMediaCapturePipelineRequest(
    sourceType: zio.aws.chimesdkmediapipelines.model.MediaPipelineSourceType,
    sourceArn: Arn,
    sinkType: zio.aws.chimesdkmediapipelines.model.MediaPipelineSinkType,
    sinkArn: Arn,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    chimeSdkMeetingConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.chimesdkmediapipelines.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineRequest = {
    import CreateMediaCapturePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineRequest
      .builder()
      .sourceType(sourceType.unwrap)
      .sourceArn(Arn.unwrap(sourceArn): java.lang.String)
      .sinkType(sinkType.unwrap)
      .sinkArn(Arn.unwrap(sinkArn): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        chimeSdkMeetingConfiguration.map(value => value.buildAwsValue())
      )(_.chimeSdkMeetingConfiguration)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineRequest
      .wrap(buildAwsValue())
}
object CreateMediaCapturePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineRequest =
      zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineRequest(
        sourceType,
        sourceArn,
        sinkType,
        sinkArn,
        clientRequestToken.map(value => value),
        chimeSdkMeetingConfiguration.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceType: zio.aws.chimesdkmediapipelines.model.MediaPipelineSourceType
    def sourceArn: Arn
    def sinkType: zio.aws.chimesdkmediapipelines.model.MediaPipelineSinkType
    def sinkArn: Arn
    def clientRequestToken: Optional[ClientRequestToken]
    def chimeSdkMeetingConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration.ReadOnly
    ]
    def tags: Optional[List[zio.aws.chimesdkmediapipelines.model.Tag.ReadOnly]]
    def getSourceType: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.MediaPipelineSourceType
    ] = ZIO.succeed(sourceType)
    def getSourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(sourceArn)
    def getSinkType: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.MediaPipelineSinkType
    ] = ZIO.succeed(sinkType)
    def getSinkArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(sinkArn)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getChimeSdkMeetingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "chimeSdkMeetingConfiguration",
      chimeSdkMeetingConfiguration
    )
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmediapipelines.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineRequest
  ) extends zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineRequest.ReadOnly {
    override val sourceType
        : zio.aws.chimesdkmediapipelines.model.MediaPipelineSourceType =
      zio.aws.chimesdkmediapipelines.model.MediaPipelineSourceType
        .wrap(impl.sourceType())
    override val sourceArn: Arn =
      zio.aws.chimesdkmediapipelines.model.primitives.Arn(impl.sourceArn())
    override val sinkType
        : zio.aws.chimesdkmediapipelines.model.MediaPipelineSinkType =
      zio.aws.chimesdkmediapipelines.model.MediaPipelineSinkType
        .wrap(impl.sinkType())
    override val sinkArn: Arn =
      zio.aws.chimesdkmediapipelines.model.primitives.Arn(impl.sinkArn())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .ClientRequestToken(value)
        )
    override val chimeSdkMeetingConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.chimeSdkMeetingConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration
          .wrap(value)
      )
    override val tags
        : Optional[List[zio.aws.chimesdkmediapipelines.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkmediapipelines.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineRequest
  ): zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineRequest.ReadOnly =
    new Wrapper(impl)
}
