package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateMediaPipelineKinesisVideoStreamPoolResponse(
    kinesisVideoStreamPoolConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolResponse = {
    import UpdateMediaPipelineKinesisVideoStreamPoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolResponse
      .builder()
      .optionallyWith(
        kinesisVideoStreamPoolConfiguration.map(value => value.buildAwsValue())
      )(_.kinesisVideoStreamPoolConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolResponse.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolResponse
      .wrap(buildAwsValue())
}
object UpdateMediaPipelineKinesisVideoStreamPoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolResponse =
      zio.aws.chimesdkmediapipelines.model
        .UpdateMediaPipelineKinesisVideoStreamPoolResponse(
          kinesisVideoStreamPoolConfiguration.map(value => value.asEditable)
        )
    def kinesisVideoStreamPoolConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration.ReadOnly
    ]
    def getKinesisVideoStreamPoolConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisVideoStreamPoolConfiguration",
      kinesisVideoStreamPoolConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolResponse
  ) extends zio.aws.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolResponse.ReadOnly {
    override val kinesisVideoStreamPoolConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisVideoStreamPoolConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolResponse
  ): zio.aws.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolResponse.ReadOnly =
    new Wrapper(impl)
}
