package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListMediaCapturePipelinesResponse(
    mediaCapturePipelines: Optional[
      Iterable[zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSummary]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse = {
    import ListMediaCapturePipelinesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse
      .builder()
      .optionallyWith(
        mediaCapturePipelines.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mediaCapturePipelines)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse
      .wrap(buildAwsValue())
}
object ListMediaCapturePipelinesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse =
      zio.aws.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse(
        mediaCapturePipelines.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def mediaCapturePipelines: Optional[List[
      zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSummary.ReadOnly
    ]]
    def nextToken: Optional[String]
    def getMediaCapturePipelines: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("mediaCapturePipelines", mediaCapturePipelines)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse
  ) extends zio.aws.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse.ReadOnly {
    override val mediaCapturePipelines: Optional[List[
      zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSummary.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaCapturePipelines())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSummary
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse
  ): zio.aws.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse.ReadOnly =
    new Wrapper(impl)
}
