package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SnsTopicSinkConfiguration(
    insightsTarget: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.SnsTopicSinkConfiguration = {
    import SnsTopicSinkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.SnsTopicSinkConfiguration
      .builder()
      .optionallyWith(
        insightsTarget.map(value => Arn.unwrap(value): java.lang.String)
      )(_.insightsTarget)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.SnsTopicSinkConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.SnsTopicSinkConfiguration
      .wrap(buildAwsValue())
}
object SnsTopicSinkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.SnsTopicSinkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.SnsTopicSinkConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .SnsTopicSinkConfiguration(insightsTarget.map(value => value))
    def insightsTarget: Optional[Arn]
    def getInsightsTarget: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("insightsTarget", insightsTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.SnsTopicSinkConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.SnsTopicSinkConfiguration.ReadOnly {
    override val insightsTarget: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.insightsTarget())
      .map(value => zio.aws.chimesdkmediapipelines.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.SnsTopicSinkConfiguration
  ): zio.aws.chimesdkmediapipelines.model.SnsTopicSinkConfiguration.ReadOnly =
    new Wrapper(impl)
}
