package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class S3RecordingSinkRuntimeConfiguration(
    destination: Arn,
    recordingFileFormat: zio.aws.chimesdkmediapipelines.model.RecordingFileFormat
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration = {
    import S3RecordingSinkRuntimeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration
      .builder()
      .destination(Arn.unwrap(destination): java.lang.String)
      .recordingFileFormat(recordingFileFormat.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration
      .wrap(buildAwsValue())
}
object S3RecordingSinkRuntimeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .S3RecordingSinkRuntimeConfiguration(destination, recordingFileFormat)
    def destination: Arn
    def recordingFileFormat
        : zio.aws.chimesdkmediapipelines.model.RecordingFileFormat
    def getDestination: ZIO[Any, Nothing, Arn] = ZIO.succeed(destination)
    def getRecordingFileFormat: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.RecordingFileFormat
    ] = ZIO.succeed(recordingFileFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration.ReadOnly {
    override val destination: Arn =
      zio.aws.chimesdkmediapipelines.model.primitives.Arn(impl.destination())
    override val recordingFileFormat
        : zio.aws.chimesdkmediapipelines.model.RecordingFileFormat =
      zio.aws.chimesdkmediapipelines.model.RecordingFileFormat
        .wrap(impl.recordingFileFormat())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration
  ): zio.aws.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration.ReadOnly =
    new Wrapper(impl)
}
