package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{
  ClientRequestToken,
  Arn,
  MediaInsightsPipelineConfigurationNameString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMediaInsightsPipelineConfigurationRequest(
    mediaInsightsPipelineConfigurationName: MediaInsightsPipelineConfigurationNameString,
    resourceAccessRoleArn: Arn,
    realTimeAlertConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration
    ] = Optional.Absent,
    elements: Iterable[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement
    ],
    tags: Optional[Iterable[zio.aws.chimesdkmediapipelines.model.Tag]] =
      Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationRequest = {
    import CreateMediaInsightsPipelineConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationRequest
      .builder()
      .mediaInsightsPipelineConfigurationName(
        MediaInsightsPipelineConfigurationNameString.unwrap(
          mediaInsightsPipelineConfigurationName
        ): java.lang.String
      )
      .resourceAccessRoleArn(
        Arn.unwrap(resourceAccessRoleArn): java.lang.String
      )
      .optionallyWith(
        realTimeAlertConfiguration.map(value => value.buildAwsValue())
      )(_.realTimeAlertConfiguration)
      .elements(elements.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateMediaInsightsPipelineConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationRequest =
      zio.aws.chimesdkmediapipelines.model
        .CreateMediaInsightsPipelineConfigurationRequest(
          mediaInsightsPipelineConfigurationName,
          resourceAccessRoleArn,
          realTimeAlertConfiguration.map(value => value.asEditable),
          elements.map { item =>
            item.asEditable
          },
          tags.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          clientRequestToken.map(value => value)
        )
    def mediaInsightsPipelineConfigurationName
        : MediaInsightsPipelineConfigurationNameString
    def resourceAccessRoleArn: Arn
    def realTimeAlertConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration.ReadOnly
    ]
    def elements: List[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.ReadOnly
    ]
    def tags: Optional[List[zio.aws.chimesdkmediapipelines.model.Tag.ReadOnly]]
    def clientRequestToken: Optional[ClientRequestToken]
    def getMediaInsightsPipelineConfigurationName
        : ZIO[Any, Nothing, MediaInsightsPipelineConfigurationNameString] =
      ZIO.succeed(mediaInsightsPipelineConfigurationName)
    def getResourceAccessRoleArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(resourceAccessRoleArn)
    def getRealTimeAlertConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "realTimeAlertConfiguration",
      realTimeAlertConfiguration
    )
    def getElements: ZIO[Any, Nothing, List[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.ReadOnly
    ]] = ZIO.succeed(elements)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmediapipelines.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationRequest
  ) extends zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationRequest.ReadOnly {
    override val mediaInsightsPipelineConfigurationName
        : MediaInsightsPipelineConfigurationNameString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .MediaInsightsPipelineConfigurationNameString(
          impl.mediaInsightsPipelineConfigurationName()
        )
    override val resourceAccessRoleArn: Arn =
      zio.aws.chimesdkmediapipelines.model.primitives
        .Arn(impl.resourceAccessRoleArn())
    override val realTimeAlertConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.realTimeAlertConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration
          .wrap(value)
      )
    override val elements: List[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.ReadOnly
    ] = impl
      .elements()
      .asScala
      .map { item =>
        zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement
          .wrap(item)
      }
      .toList
    override val tags
        : Optional[List[zio.aws.chimesdkmediapipelines.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkmediapipelines.model.Tag.wrap(item)
          }.toList
        )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationRequest
  ): zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
