package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{
  VocabularyFilterNames,
  LanguageOptions,
  VocabularyNames,
  VocabularyName,
  VocabularyFilterName,
  ModelName,
  PiiEntityTypes
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AmazonTranscribeProcessorConfiguration(
    languageCode: Optional[
      zio.aws.chimesdkmediapipelines.model.CallAnalyticsLanguageCode
    ] = Optional.Absent,
    vocabularyName: Optional[VocabularyName] = Optional.Absent,
    vocabularyFilterName: Optional[VocabularyFilterName] = Optional.Absent,
    vocabularyFilterMethod: Optional[
      zio.aws.chimesdkmediapipelines.model.VocabularyFilterMethod
    ] = Optional.Absent,
    showSpeakerLabel: Optional[Boolean] = Optional.Absent,
    enablePartialResultsStabilization: Optional[Boolean] = Optional.Absent,
    partialResultsStability: Optional[
      zio.aws.chimesdkmediapipelines.model.PartialResultsStability
    ] = Optional.Absent,
    contentIdentificationType: Optional[
      zio.aws.chimesdkmediapipelines.model.ContentType
    ] = Optional.Absent,
    contentRedactionType: Optional[
      zio.aws.chimesdkmediapipelines.model.ContentType
    ] = Optional.Absent,
    piiEntityTypes: Optional[PiiEntityTypes] = Optional.Absent,
    languageModelName: Optional[ModelName] = Optional.Absent,
    filterPartialResults: Optional[Boolean] = Optional.Absent,
    identifyLanguage: Optional[Boolean] = Optional.Absent,
    languageOptions: Optional[LanguageOptions] = Optional.Absent,
    preferredLanguage: Optional[
      zio.aws.chimesdkmediapipelines.model.CallAnalyticsLanguageCode
    ] = Optional.Absent,
    vocabularyNames: Optional[VocabularyNames] = Optional.Absent,
    vocabularyFilterNames: Optional[VocabularyFilterNames] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.AmazonTranscribeProcessorConfiguration = {
    import AmazonTranscribeProcessorConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.AmazonTranscribeProcessorConfiguration
      .builder()
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        vocabularyName.map(value =>
          VocabularyName.unwrap(value): java.lang.String
        )
      )(_.vocabularyName)
      .optionallyWith(
        vocabularyFilterName.map(value =>
          VocabularyFilterName.unwrap(value): java.lang.String
        )
      )(_.vocabularyFilterName)
      .optionallyWith(vocabularyFilterMethod.map(value => value.unwrap))(
        _.vocabularyFilterMethod
      )
      .optionallyWith(showSpeakerLabel.map(value => value: java.lang.Boolean))(
        _.showSpeakerLabel
      )
      .optionallyWith(
        enablePartialResultsStabilization.map(value => value: java.lang.Boolean)
      )(_.enablePartialResultsStabilization)
      .optionallyWith(partialResultsStability.map(value => value.unwrap))(
        _.partialResultsStability
      )
      .optionallyWith(contentIdentificationType.map(value => value.unwrap))(
        _.contentIdentificationType
      )
      .optionallyWith(contentRedactionType.map(value => value.unwrap))(
        _.contentRedactionType
      )
      .optionallyWith(
        piiEntityTypes.map(value =>
          PiiEntityTypes.unwrap(value): java.lang.String
        )
      )(_.piiEntityTypes)
      .optionallyWith(
        languageModelName.map(value =>
          ModelName.unwrap(value): java.lang.String
        )
      )(_.languageModelName)
      .optionallyWith(
        filterPartialResults.map(value => value: java.lang.Boolean)
      )(_.filterPartialResults)
      .optionallyWith(identifyLanguage.map(value => value: java.lang.Boolean))(
        _.identifyLanguage
      )
      .optionallyWith(
        languageOptions.map(value =>
          LanguageOptions.unwrap(value): java.lang.String
        )
      )(_.languageOptions)
      .optionallyWith(preferredLanguage.map(value => value.unwrap))(
        _.preferredLanguage
      )
      .optionallyWith(
        vocabularyNames.map(value =>
          VocabularyNames.unwrap(value): java.lang.String
        )
      )(_.vocabularyNames)
      .optionallyWith(
        vocabularyFilterNames.map(value =>
          VocabularyFilterNames.unwrap(value): java.lang.String
        )
      )(_.vocabularyFilterNames)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.AmazonTranscribeProcessorConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.AmazonTranscribeProcessorConfiguration
      .wrap(buildAwsValue())
}
object AmazonTranscribeProcessorConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.AmazonTranscribeProcessorConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.AmazonTranscribeProcessorConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .AmazonTranscribeProcessorConfiguration(
          languageCode.map(value => value),
          vocabularyName.map(value => value),
          vocabularyFilterName.map(value => value),
          vocabularyFilterMethod.map(value => value),
          showSpeakerLabel.map(value => value),
          enablePartialResultsStabilization.map(value => value),
          partialResultsStability.map(value => value),
          contentIdentificationType.map(value => value),
          contentRedactionType.map(value => value),
          piiEntityTypes.map(value => value),
          languageModelName.map(value => value),
          filterPartialResults.map(value => value),
          identifyLanguage.map(value => value),
          languageOptions.map(value => value),
          preferredLanguage.map(value => value),
          vocabularyNames.map(value => value),
          vocabularyFilterNames.map(value => value)
        )
    def languageCode: Optional[
      zio.aws.chimesdkmediapipelines.model.CallAnalyticsLanguageCode
    ]
    def vocabularyName: Optional[VocabularyName]
    def vocabularyFilterName: Optional[VocabularyFilterName]
    def vocabularyFilterMethod
        : Optional[zio.aws.chimesdkmediapipelines.model.VocabularyFilterMethod]
    def showSpeakerLabel: Optional[Boolean]
    def enablePartialResultsStabilization: Optional[Boolean]
    def partialResultsStability
        : Optional[zio.aws.chimesdkmediapipelines.model.PartialResultsStability]
    def contentIdentificationType
        : Optional[zio.aws.chimesdkmediapipelines.model.ContentType]
    def contentRedactionType
        : Optional[zio.aws.chimesdkmediapipelines.model.ContentType]
    def piiEntityTypes: Optional[PiiEntityTypes]
    def languageModelName: Optional[ModelName]
    def filterPartialResults: Optional[Boolean]
    def identifyLanguage: Optional[Boolean]
    def languageOptions: Optional[LanguageOptions]
    def preferredLanguage: Optional[
      zio.aws.chimesdkmediapipelines.model.CallAnalyticsLanguageCode
    ]
    def vocabularyNames: Optional[VocabularyNames]
    def vocabularyFilterNames: Optional[VocabularyFilterNames]
    def getLanguageCode: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.CallAnalyticsLanguageCode
    ] = AwsError.unwrapOptionField("languageCode", languageCode)
    def getVocabularyName: ZIO[Any, AwsError, VocabularyName] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
    def getVocabularyFilterName: ZIO[Any, AwsError, VocabularyFilterName] =
      AwsError.unwrapOptionField("vocabularyFilterName", vocabularyFilterName)
    def getVocabularyFilterMethod: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.VocabularyFilterMethod
    ] = AwsError.unwrapOptionField(
      "vocabularyFilterMethod",
      vocabularyFilterMethod
    )
    def getShowSpeakerLabel: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("showSpeakerLabel", showSpeakerLabel)
    def getEnablePartialResultsStabilization: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enablePartialResultsStabilization",
        enablePartialResultsStabilization
      )
    def getPartialResultsStability: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.PartialResultsStability
    ] = AwsError.unwrapOptionField(
      "partialResultsStability",
      partialResultsStability
    )
    def getContentIdentificationType
        : ZIO[Any, AwsError, zio.aws.chimesdkmediapipelines.model.ContentType] =
      AwsError.unwrapOptionField(
        "contentIdentificationType",
        contentIdentificationType
      )
    def getContentRedactionType
        : ZIO[Any, AwsError, zio.aws.chimesdkmediapipelines.model.ContentType] =
      AwsError.unwrapOptionField("contentRedactionType", contentRedactionType)
    def getPiiEntityTypes: ZIO[Any, AwsError, PiiEntityTypes] =
      AwsError.unwrapOptionField("piiEntityTypes", piiEntityTypes)
    def getLanguageModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("languageModelName", languageModelName)
    def getFilterPartialResults: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("filterPartialResults", filterPartialResults)
    def getIdentifyLanguage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("identifyLanguage", identifyLanguage)
    def getLanguageOptions: ZIO[Any, AwsError, LanguageOptions] =
      AwsError.unwrapOptionField("languageOptions", languageOptions)
    def getPreferredLanguage: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.CallAnalyticsLanguageCode
    ] = AwsError.unwrapOptionField("preferredLanguage", preferredLanguage)
    def getVocabularyNames: ZIO[Any, AwsError, VocabularyNames] =
      AwsError.unwrapOptionField("vocabularyNames", vocabularyNames)
    def getVocabularyFilterNames: ZIO[Any, AwsError, VocabularyFilterNames] =
      AwsError.unwrapOptionField("vocabularyFilterNames", vocabularyFilterNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.AmazonTranscribeProcessorConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.AmazonTranscribeProcessorConfiguration.ReadOnly {
    override val languageCode: Optional[
      zio.aws.chimesdkmediapipelines.model.CallAnalyticsLanguageCode
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.languageCode())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.CallAnalyticsLanguageCode
          .wrap(value)
      )
    override val vocabularyName: Optional[VocabularyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyName())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives.VocabularyName(value)
        )
    override val vocabularyFilterName: Optional[VocabularyFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyFilterName())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .VocabularyFilterName(value)
        )
    override val vocabularyFilterMethod: Optional[
      zio.aws.chimesdkmediapipelines.model.VocabularyFilterMethod
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vocabularyFilterMethod())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.VocabularyFilterMethod.wrap(value)
      )
    override val showSpeakerLabel: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.showSpeakerLabel())
      .map(value => value: Boolean)
    override val enablePartialResultsStabilization: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablePartialResultsStabilization())
        .map(value => value: Boolean)
    override val partialResultsStability: Optional[
      zio.aws.chimesdkmediapipelines.model.PartialResultsStability
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.partialResultsStability())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.PartialResultsStability.wrap(value)
      )
    override val contentIdentificationType
        : Optional[zio.aws.chimesdkmediapipelines.model.ContentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentIdentificationType())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.ContentType.wrap(value)
        )
    override val contentRedactionType
        : Optional[zio.aws.chimesdkmediapipelines.model.ContentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentRedactionType())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.ContentType.wrap(value)
        )
    override val piiEntityTypes: Optional[PiiEntityTypes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.piiEntityTypes())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives.PiiEntityTypes(value)
        )
    override val languageModelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.languageModelName())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.primitives.ModelName(value)
      )
    override val filterPartialResults: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.filterPartialResults())
      .map(value => value: Boolean)
    override val identifyLanguage: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.identifyLanguage())
      .map(value => value: Boolean)
    override val languageOptions: Optional[LanguageOptions] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageOptions())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives.LanguageOptions(value)
        )
    override val preferredLanguage: Optional[
      zio.aws.chimesdkmediapipelines.model.CallAnalyticsLanguageCode
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredLanguage())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.CallAnalyticsLanguageCode
          .wrap(value)
      )
    override val vocabularyNames: Optional[VocabularyNames] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyNames())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives.VocabularyNames(value)
        )
    override val vocabularyFilterNames: Optional[VocabularyFilterNames] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyFilterNames())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .VocabularyFilterNames(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.AmazonTranscribeProcessorConfiguration
  ): zio.aws.chimesdkmediapipelines.model.AmazonTranscribeProcessorConfiguration.ReadOnly =
    new Wrapper(impl)
}
