package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AudioArtifactsConfiguration(
    muxType: zio.aws.chimesdkmediapipelines.model.AudioMuxType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioArtifactsConfiguration = {
    import AudioArtifactsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioArtifactsConfiguration
      .builder()
      .muxType(muxType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.AudioArtifactsConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.AudioArtifactsConfiguration
      .wrap(buildAwsValue())
}
object AudioArtifactsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioArtifactsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.AudioArtifactsConfiguration =
      zio.aws.chimesdkmediapipelines.model.AudioArtifactsConfiguration(muxType)
    def muxType: zio.aws.chimesdkmediapipelines.model.AudioMuxType
    def getMuxType
        : ZIO[Any, Nothing, zio.aws.chimesdkmediapipelines.model.AudioMuxType] =
      ZIO.succeed(muxType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioArtifactsConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.AudioArtifactsConfiguration.ReadOnly {
    override val muxType: zio.aws.chimesdkmediapipelines.model.AudioMuxType =
      zio.aws.chimesdkmediapipelines.model.AudioMuxType.wrap(impl.muxType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioArtifactsConfiguration
  ): zio.aws.chimesdkmediapipelines.model.AudioArtifactsConfiguration.ReadOnly =
    new Wrapper(impl)
}
