package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class LiveConnectorSourceConfiguration(
    sourceType: zio.aws.chimesdkmediapipelines.model.LiveConnectorSourceType,
    chimeSdkMeetingLiveConnectorConfiguration: zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingLiveConnectorConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSourceConfiguration = {
    import LiveConnectorSourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSourceConfiguration
      .builder()
      .sourceType(sourceType.unwrap)
      .chimeSdkMeetingLiveConnectorConfiguration(
        chimeSdkMeetingLiveConnectorConfiguration.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.LiveConnectorSourceConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.LiveConnectorSourceConfiguration
      .wrap(buildAwsValue())
}
object LiveConnectorSourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.LiveConnectorSourceConfiguration =
      zio.aws.chimesdkmediapipelines.model.LiveConnectorSourceConfiguration(
        sourceType,
        chimeSdkMeetingLiveConnectorConfiguration.asEditable
      )
    def sourceType: zio.aws.chimesdkmediapipelines.model.LiveConnectorSourceType
    def chimeSdkMeetingLiveConnectorConfiguration
        : zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingLiveConnectorConfiguration.ReadOnly
    def getSourceType: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.LiveConnectorSourceType
    ] = ZIO.succeed(sourceType)
    def getChimeSdkMeetingLiveConnectorConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingLiveConnectorConfiguration.ReadOnly
    ] = ZIO.succeed(chimeSdkMeetingLiveConnectorConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSourceConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.LiveConnectorSourceConfiguration.ReadOnly {
    override val sourceType
        : zio.aws.chimesdkmediapipelines.model.LiveConnectorSourceType =
      zio.aws.chimesdkmediapipelines.model.LiveConnectorSourceType
        .wrap(impl.sourceType())
    override val chimeSdkMeetingLiveConnectorConfiguration
        : zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingLiveConnectorConfiguration.ReadOnly =
      zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingLiveConnectorConfiguration
        .wrap(impl.chimeSdkMeetingLiveConnectorConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSourceConfiguration
  ): zio.aws.chimesdkmediapipelines.model.LiveConnectorSourceConfiguration.ReadOnly =
    new Wrapper(impl)
}
