package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CompositedVideoArtifactsConfiguration(
    layout: Optional[zio.aws.chimesdkmediapipelines.model.LayoutOption] =
      Optional.Absent,
    resolution: Optional[
      zio.aws.chimesdkmediapipelines.model.ResolutionOption
    ] = Optional.Absent,
    gridViewConfiguration: zio.aws.chimesdkmediapipelines.model.GridViewConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.CompositedVideoArtifactsConfiguration = {
    import CompositedVideoArtifactsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CompositedVideoArtifactsConfiguration
      .builder()
      .optionallyWith(layout.map(value => value.unwrap))(_.layout)
      .optionallyWith(resolution.map(value => value.unwrap))(_.resolution)
      .gridViewConfiguration(gridViewConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.CompositedVideoArtifactsConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.CompositedVideoArtifactsConfiguration
      .wrap(buildAwsValue())
}
object CompositedVideoArtifactsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CompositedVideoArtifactsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.CompositedVideoArtifactsConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .CompositedVideoArtifactsConfiguration(
          layout.map(value => value),
          resolution.map(value => value),
          gridViewConfiguration.asEditable
        )
    def layout: Optional[zio.aws.chimesdkmediapipelines.model.LayoutOption]
    def resolution
        : Optional[zio.aws.chimesdkmediapipelines.model.ResolutionOption]
    def gridViewConfiguration
        : zio.aws.chimesdkmediapipelines.model.GridViewConfiguration.ReadOnly
    def getLayout: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.LayoutOption
    ] = AwsError.unwrapOptionField("layout", layout)
    def getResolution: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.ResolutionOption
    ] = AwsError.unwrapOptionField("resolution", resolution)
    def getGridViewConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.GridViewConfiguration.ReadOnly
    ] = ZIO.succeed(gridViewConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CompositedVideoArtifactsConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.CompositedVideoArtifactsConfiguration.ReadOnly {
    override val layout
        : Optional[zio.aws.chimesdkmediapipelines.model.LayoutOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.layout())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.LayoutOption.wrap(value)
        )
    override val resolution
        : Optional[zio.aws.chimesdkmediapipelines.model.ResolutionOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolution())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.ResolutionOption.wrap(value)
        )
    override val gridViewConfiguration
        : zio.aws.chimesdkmediapipelines.model.GridViewConfiguration.ReadOnly =
      zio.aws.chimesdkmediapipelines.model.GridViewConfiguration
        .wrap(impl.gridViewConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CompositedVideoArtifactsConfiguration
  ): zio.aws.chimesdkmediapipelines.model.CompositedVideoArtifactsConfiguration.ReadOnly =
    new Wrapper(impl)
}
