package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{TagValue, TagKey}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Tag(key: TagKey, value: TagValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .value(TagValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmediapipelines.model.Tag.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmediapipelines.model.Tag =
      zio.aws.chimesdkmediapipelines.model.Tag(key, value)
    def key: TagKey
    def value: TagValue
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag
  ) extends zio.aws.chimesdkmediapipelines.model.Tag.ReadOnly {
    override val key: TagKey =
      zio.aws.chimesdkmediapipelines.model.primitives.TagKey(impl.key())
    override val value: TagValue =
      zio.aws.chimesdkmediapipelines.model.primitives.TagValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag
  ): zio.aws.chimesdkmediapipelines.model.Tag.ReadOnly = new Wrapper(impl)
}
