package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GridViewConfiguration(
    contentShareLayout: zio.aws.chimesdkmediapipelines.model.ContentShareLayoutOption,
    presenterOnlyConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.PresenterOnlyConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.GridViewConfiguration = {
    import GridViewConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GridViewConfiguration
      .builder()
      .contentShareLayout(contentShareLayout.unwrap)
      .optionallyWith(
        presenterOnlyConfiguration.map(value => value.buildAwsValue())
      )(_.presenterOnlyConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.GridViewConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.GridViewConfiguration
      .wrap(buildAwsValue())
}
object GridViewConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GridViewConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmediapipelines.model.GridViewConfiguration =
      zio.aws.chimesdkmediapipelines.model.GridViewConfiguration(
        contentShareLayout,
        presenterOnlyConfiguration.map(value => value.asEditable)
      )
    def contentShareLayout
        : zio.aws.chimesdkmediapipelines.model.ContentShareLayoutOption
    def presenterOnlyConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.PresenterOnlyConfiguration.ReadOnly
    ]
    def getContentShareLayout: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.ContentShareLayoutOption
    ] = ZIO.succeed(contentShareLayout)
    def getPresenterOnlyConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.PresenterOnlyConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "presenterOnlyConfiguration",
      presenterOnlyConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GridViewConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.GridViewConfiguration.ReadOnly {
    override val contentShareLayout
        : zio.aws.chimesdkmediapipelines.model.ContentShareLayoutOption =
      zio.aws.chimesdkmediapipelines.model.ContentShareLayoutOption
        .wrap(impl.contentShareLayout())
    override val presenterOnlyConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.PresenterOnlyConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.presenterOnlyConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.PresenterOnlyConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GridViewConfiguration
  ): zio.aws.chimesdkmediapipelines.model.GridViewConfiguration.ReadOnly =
    new Wrapper(impl)
}
