package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMediaConcatenationPipelineResponse(
    mediaConcatenationPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaConcatenationPipeline
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse = {
    import CreateMediaConcatenationPipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse
      .builder()
      .optionallyWith(
        mediaConcatenationPipeline.map(value => value.buildAwsValue())
      )(_.mediaConcatenationPipeline)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse
      .wrap(buildAwsValue())
}
object CreateMediaConcatenationPipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse =
      zio.aws.chimesdkmediapipelines.model
        .CreateMediaConcatenationPipelineResponse(
          mediaConcatenationPipeline.map(value => value.asEditable)
        )
    def mediaConcatenationPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaConcatenationPipeline.ReadOnly
    ]
    def getMediaConcatenationPipeline: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaConcatenationPipeline.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mediaConcatenationPipeline",
      mediaConcatenationPipeline
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse
  ) extends zio.aws.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse.ReadOnly {
    override val mediaConcatenationPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaConcatenationPipeline.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaConcatenationPipeline())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.MediaConcatenationPipeline
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse
  ): zio.aws.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse.ReadOnly =
    new Wrapper(impl)
}
