package zio.aws.chimesdkmediapipelines.model
import scala.jdk.CollectionConverters._
sealed trait MediaPipelineSourceType {
  def unwrap: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSourceType
}
object MediaPipelineSourceType {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSourceType
  ): zio.aws.chimesdkmediapipelines.model.MediaPipelineSourceType =
    value match {
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSourceType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSourceType.CHIME_SDK_MEETING =>
        val r = ChimeSdkMeeting
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineSourceType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSourceType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ChimeSdkMeeting
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineSourceType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSourceType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSourceType.CHIME_SDK_MEETING
  }
}
