package zio.aws.chimesdkmediapipelines
import zio.aws.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.chimesdkmediapipelines.ChimeSdkMediaPipelinesAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.chimesdkmediapipelines.model.{
  GetMediaCapturePipelineRequest,
  ListMediaCapturePipelinesRequest,
  ListTagsForResourceRequest,
  DeleteMediaCapturePipelineRequest,
  CreateMediaCapturePipelineRequest,
  UntagResourceRequest,
  TagResourceRequest
}
import zio.stream.ZStream
object ChimeSdkMediaPipelinesMock extends Mock[ChimeSdkMediaPipelines] {
  object GetMediaCapturePipeline
      extends Effect[
        GetMediaCapturePipelineRequest,
        AwsError,
        zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.chimesdkmediapipelines.model.UntagResourceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.chimesdkmediapipelines.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.chimesdkmediapipelines.model.TagResourceResponse.ReadOnly
      ]
  object CreateMediaCapturePipeline
      extends Effect[
        CreateMediaCapturePipelineRequest,
        AwsError,
        zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse.ReadOnly
      ]
  object DeleteMediaCapturePipeline
      extends Effect[DeleteMediaCapturePipelineRequest, AwsError, Unit]
  object ListMediaCapturePipelines
      extends Stream[
        ListMediaCapturePipelinesRequest,
        AwsError,
        zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSummary.ReadOnly
      ]
  object ListMediaCapturePipelinesPaginated
      extends Effect[ListMediaCapturePipelinesRequest, AwsError, ReadOnly]
  val compose: URLayer[Proxy, ChimeSdkMediaPipelines] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ChimeSdkMediaPipelines] { rts =>
        zio.ZIO.succeed {
          new ChimeSdkMediaPipelines {
            val api: ChimeSdkMediaPipelinesAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ChimeSdkMediaPipelines = this
            def getMediaCapturePipeline(
                request: GetMediaCapturePipelineRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse.ReadOnly
            ] = proxy(GetMediaCapturePipeline, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.chimesdkmediapipelines.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.chimesdkmediapipelines.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.chimesdkmediapipelines.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def createMediaCapturePipeline(
                request: CreateMediaCapturePipelineRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse.ReadOnly
            ] = proxy(CreateMediaCapturePipeline, request)
            def deleteMediaCapturePipeline(
                request: DeleteMediaCapturePipelineRequest
            ): IO[AwsError, Unit] = proxy(DeleteMediaCapturePipeline, request)
            def listMediaCapturePipelines(
                request: ListMediaCapturePipelinesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMediaCapturePipelines, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMediaCapturePipelinesPaginated(
                request: ListMediaCapturePipelinesRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListMediaCapturePipelinesPaginated, request)
          }
        }
      }
    }
  }
}
