package zio.aws.braket.model
import scala.jdk.CollectionConverters.*
sealed trait QueuePriority {
  def unwrap: software.amazon.awssdk.services.braket.model.QueuePriority
}
object QueuePriority {
  def wrap(
      value: software.amazon.awssdk.services.braket.model.QueuePriority
  ): zio.aws.braket.model.QueuePriority = value match {
    case software.amazon.awssdk.services.braket.model.QueuePriority.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.braket.model.QueuePriority.NORMAL =>
      val r = Normal
      r
    case software.amazon.awssdk.services.braket.model.QueuePriority.PRIORITY =>
      val r = Priority
      r
  }
  case object unknownToSdkVersion extends zio.aws.braket.model.QueuePriority {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.QueuePriority =
      software.amazon.awssdk.services.braket.model.QueuePriority.UNKNOWN_TO_SDK_VERSION
  }
  case object Normal extends zio.aws.braket.model.QueuePriority {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.QueuePriority =
      software.amazon.awssdk.services.braket.model.QueuePriority.NORMAL
  }
  case object Priority extends zio.aws.braket.model.QueuePriority {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.QueuePriority =
      software.amazon.awssdk.services.braket.model.QueuePriority.PRIORITY
  }
}
