package zio.aws.braket.model
import scala.jdk.CollectionConverters.*
sealed trait QueueName {
  def unwrap: software.amazon.awssdk.services.braket.model.QueueName
}
object QueueName {
  def wrap(
      value: software.amazon.awssdk.services.braket.model.QueueName
  ): zio.aws.braket.model.QueueName = value match {
    case software.amazon.awssdk.services.braket.model.QueueName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.braket.model.QueueName.QUANTUM_TASKS_QUEUE =>
      val r = QUANTUM_TASKS_QUEUE
      r
    case software.amazon.awssdk.services.braket.model.QueueName.JOBS_QUEUE =>
      val r = JOBS_QUEUE
      r
  }
  case object unknownToSdkVersion extends zio.aws.braket.model.QueueName {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.QueueName =
      software.amazon.awssdk.services.braket.model.QueueName.UNKNOWN_TO_SDK_VERSION
  }
  case object QUANTUM_TASKS_QUEUE extends zio.aws.braket.model.QueueName {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.QueueName =
      software.amazon.awssdk.services.braket.model.QueueName.QUANTUM_TASKS_QUEUE
  }
  case object JOBS_QUEUE extends zio.aws.braket.model.QueueName {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.QueueName =
      software.amazon.awssdk.services.braket.model.QueueName.JOBS_QUEUE
  }
}
