package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class QuantumTaskQueueInfo(
    message: Optional[String] = Optional.Absent,
    position: String,
    queue: zio.aws.braket.model.QueueName,
    queuePriority: Optional[zio.aws.braket.model.QueuePriority] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.QuantumTaskQueueInfo = {
    import QuantumTaskQueueInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.QuantumTaskQueueInfo
      .builder()
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .position(position: java.lang.String)
      .queue(queue.unwrap)
      .optionallyWith(queuePriority.map(value => value.unwrap))(_.queuePriority)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.QuantumTaskQueueInfo.ReadOnly =
    zio.aws.braket.model.QuantumTaskQueueInfo.wrap(buildAwsValue())
}
object QuantumTaskQueueInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.QuantumTaskQueueInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.QuantumTaskQueueInfo =
      zio.aws.braket.model.QuantumTaskQueueInfo(
        message.map(value => value),
        position,
        queue,
        queuePriority.map(value => value)
      )
    def message: Optional[String]
    def position: String
    def queue: zio.aws.braket.model.QueueName
    def queuePriority: Optional[zio.aws.braket.model.QueuePriority]
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getPosition: ZIO[Any, Nothing, String] = ZIO.succeed(position)
    def getQueue: ZIO[Any, Nothing, zio.aws.braket.model.QueueName] =
      ZIO.succeed(queue)
    def getQueuePriority
        : ZIO[Any, AwsError, zio.aws.braket.model.QueuePriority] =
      AwsError.unwrapOptionField("queuePriority", queuePriority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.QuantumTaskQueueInfo
  ) extends zio.aws.braket.model.QuantumTaskQueueInfo.ReadOnly {
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val position: String = impl.position(): String
    override val queue: zio.aws.braket.model.QueueName =
      zio.aws.braket.model.QueueName.wrap(impl.queue())
    override val queuePriority: Optional[zio.aws.braket.model.QueuePriority] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queuePriority())
        .map(value => zio.aws.braket.model.QueuePriority.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.QuantumTaskQueueInfo
  ): zio.aws.braket.model.QuantumTaskQueueInfo.ReadOnly = new Wrapper(impl)
}
