package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.braket.model.primitives.{S3Path, String4096}
import scala.jdk.CollectionConverters.*
final case class JobCheckpointConfig(
    localPath: Optional[String4096] = Optional.Absent,
    s3Uri: S3Path
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.JobCheckpointConfig = {
    import JobCheckpointConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.JobCheckpointConfig
      .builder()
      .optionallyWith(
        localPath.map(value => String4096.unwrap(value): java.lang.String)
      )(_.localPath)
      .s3Uri(S3Path.unwrap(s3Uri): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.JobCheckpointConfig.ReadOnly =
    zio.aws.braket.model.JobCheckpointConfig.wrap(buildAwsValue())
}
object JobCheckpointConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.JobCheckpointConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.JobCheckpointConfig =
      zio.aws.braket.model
        .JobCheckpointConfig(localPath.map(value => value), s3Uri)
    def localPath: Optional[String4096]
    def s3Uri: S3Path
    def getLocalPath: ZIO[Any, AwsError, String4096] =
      AwsError.unwrapOptionField("localPath", localPath)
    def getS3Uri: ZIO[Any, Nothing, S3Path] = ZIO.succeed(s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.JobCheckpointConfig
  ) extends zio.aws.braket.model.JobCheckpointConfig.ReadOnly {
    override val localPath: Optional[String4096] = zio.aws.core.internal
      .optionalFromNullable(impl.localPath())
      .map(value => zio.aws.braket.model.primitives.String4096(value))
    override val s3Uri: S3Path =
      zio.aws.braket.model.primitives.S3Path(impl.s3Uri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.JobCheckpointConfig
  ): zio.aws.braket.model.JobCheckpointConfig.ReadOnly = new Wrapper(impl)
}
