package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HybridJobQueueInfo(
    message: Optional[String] = Optional.Absent,
    position: String,
    queue: zio.aws.braket.model.QueueName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.HybridJobQueueInfo = {
    import HybridJobQueueInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.HybridJobQueueInfo
      .builder()
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .position(position: java.lang.String)
      .queue(queue.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.HybridJobQueueInfo.ReadOnly =
    zio.aws.braket.model.HybridJobQueueInfo.wrap(buildAwsValue())
}
object HybridJobQueueInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.HybridJobQueueInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.HybridJobQueueInfo =
      zio.aws.braket.model
        .HybridJobQueueInfo(message.map(value => value), position, queue)
    def message: Optional[String]
    def position: String
    def queue: zio.aws.braket.model.QueueName
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getPosition: ZIO[Any, Nothing, String] = ZIO.succeed(position)
    def getQueue: ZIO[Any, Nothing, zio.aws.braket.model.QueueName] =
      ZIO.succeed(queue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.HybridJobQueueInfo
  ) extends zio.aws.braket.model.HybridJobQueueInfo.ReadOnly {
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val position: String = impl.position(): String
    override val queue: zio.aws.braket.model.QueueName =
      zio.aws.braket.model.QueueName.wrap(impl.queue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.HybridJobQueueInfo
  ): zio.aws.braket.model.HybridJobQueueInfo.ReadOnly = new Wrapper(impl)
}
